/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.infra.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import fr.enedis.chutney.campaign.infra.CampaignExecutionJpaRepository;
import fr.enedis.chutney.campaign.infra.CampaignJpaRepository;
import fr.enedis.chutney.campaign.infra.jpa.CampaignEntity;
import fr.enedis.chutney.campaign.infra.jpa.CampaignExecutionEntity;
import fr.enedis.chutney.execution.infra.storage.DatabaseExecutionJpaRepository;
import fr.enedis.chutney.execution.infra.storage.ScenarioExecutionReportJpaRepository;
import fr.enedis.chutney.execution.infra.storage.index.ExecutionReportIndexRepository;
import fr.enedis.chutney.execution.infra.storage.jpa.ScenarioExecutionEntity;
import fr.enedis.chutney.execution.infra.storage.jpa.ScenarioExecutionReportEntity;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistory;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistoryRepository;
import fr.enedis.chutney.server.core.domain.execution.history.ImmutableExecutionHistory;
import fr.enedis.chutney.server.core.domain.execution.history.PurgeReport;
import fr.enedis.chutney.server.core.domain.execution.report.ReportNotFoundException;
import fr.enedis.chutney.server.core.domain.execution.report.ScenarioExecutionReport;
import fr.enedis.chutney.server.core.domain.execution.report.ServerReportStatus;
import fr.enedis.chutney.server.core.domain.execution.report.StepExecutionReportCore;
import fr.enedis.chutney.server.core.domain.scenario.TestCaseRepository;
import fr.enedis.chutney.server.core.domain.scenario.campaign.CampaignExecution;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
class DatabaseExecutionHistoryRepository
implements ExecutionHistoryRepository {
    private final DatabaseExecutionJpaRepository scenarioExecutionsJpaRepository;
    private final ScenarioExecutionReportJpaRepository scenarioExecutionReportJpaRepository;
    private final CampaignJpaRepository campaignJpaRepository;
    private final CampaignExecutionJpaRepository campaignExecutionJpaRepository;
    private final TestCaseRepository testCaseRepository;
    private final ExecutionReportIndexRepository executionReportIndexRepository;
    private final ObjectMapper objectMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseExecutionHistoryRepository.class);

    DatabaseExecutionHistoryRepository(DatabaseExecutionJpaRepository scenarioExecutionsJpaRepository, ScenarioExecutionReportJpaRepository scenarioExecutionReportJpaRepository, CampaignJpaRepository campaignJpaRepository, TestCaseRepository testCaseRepository, CampaignExecutionJpaRepository campaignExecutionJpaRepository, ExecutionReportIndexRepository executionReportIndexRepository, @Qualifier(value="reportObjectMapper") ObjectMapper objectMapper) {
        this.scenarioExecutionsJpaRepository = scenarioExecutionsJpaRepository;
        this.scenarioExecutionReportJpaRepository = scenarioExecutionReportJpaRepository;
        this.campaignJpaRepository = campaignJpaRepository;
        this.testCaseRepository = testCaseRepository;
        this.campaignExecutionJpaRepository = campaignExecutionJpaRepository;
        this.executionReportIndexRepository = executionReportIndexRepository;
        this.objectMapper = objectMapper;
    }

    public Map<String, ExecutionHistory.ExecutionSummary> getLastExecutions(List<String> scenariosIds) {
        List<String> validScenariosIds = scenariosIds.stream().filter(id -> !this.invalidScenarioId((String)id)).toList();
        List<Long> executionsIds = this.scenarioExecutionsJpaRepository.findLastByStatusAndScenariosIds(validScenariosIds, ServerReportStatus.RUNNING).stream().map(t -> (Long)t.get(0, Long.class)).toList();
        List lastExecutions = this.scenarioExecutionsJpaRepository.findAllById(executionsIds);
        return StreamSupport.stream(lastExecutions.spliterator(), true).collect(Collectors.toMap(ScenarioExecutionEntity::scenarioId, ScenarioExecutionEntity::toDomain));
    }

    public List<ExecutionHistory.ExecutionSummary> getExecutions(String scenarioId) {
        if (this.invalidScenarioId(scenarioId)) {
            return Collections.emptyList();
        }
        List<ScenarioExecutionEntity> scenarioExecutions = this.scenarioExecutionsJpaRepository.findByScenarioIdOrderByIdDesc(scenarioId);
        return scenarioExecutions.stream().map(this::scenarioExecutionToExecutionSummary).toList();
    }

    public List<ExecutionHistory.ExecutionSummary> getExecutions() {
        return this.scenarioExecutionsJpaRepository.findAll().stream().map(this::scenarioExecutionToExecutionSummary).toList();
    }

    public ExecutionHistory.ExecutionSummary getExecutionSummary(Long executionId) {
        return this.scenarioExecutionsJpaRepository.findById(executionId).map(this::scenarioExecutionToExecutionSummary).orElseThrow(() -> new ReportNotFoundException(executionId));
    }

    private ExecutionHistory.ExecutionSummary scenarioExecutionToExecutionSummary(ScenarioExecutionEntity scenarioExecution) {
        CampaignExecution campaignExecution = Optional.ofNullable(scenarioExecution.campaignExecution()).map(ce -> ce.toDomain(((CampaignEntity)this.campaignJpaRepository.findById(ce.campaignId()).get()).title())).orElse(null);
        return scenarioExecution.toDomain(campaignExecution);
    }

    @Transactional
    public ExecutionHistory.Execution store(String scenarioId, ExecutionHistory.DetachedExecution detachedExecution) throws IllegalStateException {
        if (this.invalidScenarioId(scenarioId)) {
            throw new IllegalStateException("Scenario id is null or empty");
        }
        ScenarioExecutionEntity scenarioExecution = ScenarioExecutionEntity.fromDomain(scenarioId, (ExecutionHistory.ExecutionProperties)detachedExecution);
        if (detachedExecution.campaignReport().isPresent()) {
            Optional campaignExecution = this.campaignExecutionJpaRepository.findById(((CampaignExecution)detachedExecution.campaignReport().get()).executionId);
            scenarioExecution.forCampaignExecution((CampaignExecutionEntity)campaignExecution.get());
        }
        scenarioExecution = (ScenarioExecutionEntity)this.scenarioExecutionsJpaRepository.save(scenarioExecution);
        ScenarioExecutionReportEntity reportEntity = new ScenarioExecutionReportEntity(scenarioExecution, detachedExecution.report());
        this.scenarioExecutionReportJpaRepository.save(reportEntity);
        ExecutionHistory.Execution execution = detachedExecution.attach(scenarioExecution.id().longValue(), scenarioId);
        return ImmutableExecutionHistory.Execution.builder().from(execution).build();
    }

    public ExecutionHistory.Execution getExecution(String scenarioId, Long reportId) throws ReportNotFoundException {
        if (this.invalidScenarioId(scenarioId) || this.testCaseRepository.findById(scenarioId).isEmpty()) {
            throw new ReportNotFoundException(scenarioId, reportId);
        }
        return this.scenarioExecutionReportJpaRepository.findById(reportId).map(ScenarioExecutionReportEntity::toDomain).orElseThrow(() -> new ReportNotFoundException(scenarioId, reportId));
    }

    public List<ExecutionHistory.ExecutionSummary> getExecutionReportMatchKeyword(String keyword) {
        List<Long> matchedReportsIds = this.executionReportIndexRepository.idsByKeywordInReport(keyword);
        return this.scenarioExecutionsJpaRepository.getExecutionReportByIds(matchedReportsIds).stream().map(this::scenarioExecutionToExecutionSummary).toList();
    }

    @Transactional
    public void update(String scenarioId, ExecutionHistory.Execution updatedExecution) throws ReportNotFoundException {
        if (!this.scenarioExecutionsJpaRepository.existsById(updatedExecution.executionId())) {
            throw new ReportNotFoundException(scenarioId, updatedExecution.executionId());
        }
        this.update(updatedExecution);
    }

    private void update(ExecutionHistory.Execution updatedExecution) throws ReportNotFoundException {
        ScenarioExecutionEntity execution = (ScenarioExecutionEntity)this.scenarioExecutionsJpaRepository.findById(updatedExecution.executionId()).orElseThrow(() -> new ReportNotFoundException(updatedExecution.executionId()));
        execution.updateFromExecution(updatedExecution);
        this.scenarioExecutionsJpaRepository.save(execution);
        this.updateReport(updatedExecution);
    }

    private void updateReport(ExecutionHistory.Execution execution) throws ReportNotFoundException {
        ScenarioExecutionReportEntity scenarioExecutionReport = (ScenarioExecutionReportEntity)this.scenarioExecutionReportJpaRepository.findById(execution.executionId()).orElseThrow(() -> new ReportNotFoundException(execution.executionId()));
        scenarioExecutionReport.updateReport(execution);
        this.scenarioExecutionReportJpaRepository.save(scenarioExecutionReport);
    }

    @Transactional
    public int setAllRunningExecutionsToKO() {
        List<ExecutionHistory.ExecutionSummary> runningExecutions = this.getExecutionsWithStatus(ServerReportStatus.RUNNING);
        this.updateExecutionsToKO(runningExecutions);
        List<ExecutionHistory.ExecutionSummary> pausedExecutions = this.getExecutionsWithStatus(ServerReportStatus.PAUSED);
        this.updateExecutionsToKO(pausedExecutions);
        return runningExecutions.size() + pausedExecutions.size();
    }

    public List<ExecutionHistory.ExecutionSummary> getExecutionsWithStatus(ServerReportStatus status) {
        return this.scenarioExecutionsJpaRepository.findByStatus(status).stream().map(ScenarioExecutionEntity::toDomain).toList();
    }

    @Transactional
    public PurgeReport deleteExecutions(Set<Long> executionsIds) {
        Set finalScenariosExecutions = executionsIds.stream().map(this::getExecutionSummary).filter(executionSummary -> executionSummary.status().isFinal()).collect(Collectors.toUnmodifiableSet());
        Set<Long> toDeleteScenariosExecutionsIds = finalScenariosExecutions.stream().map(ExecutionHistory.Attached::executionId).collect(Collectors.toUnmodifiableSet());
        Set<Long> toDeleteCampaignsExecutionsIds = this.getCampaignExecutionsToDelete(toDeleteScenariosExecutionsIds);
        this.campaignExecutionJpaRepository.deleteAllByIdInBatch(toDeleteCampaignsExecutionsIds);
        this.scenarioExecutionReportJpaRepository.deleteAllById(toDeleteScenariosExecutionsIds);
        this.scenarioExecutionsJpaRepository.deleteAllByIdInBatch(toDeleteScenariosExecutionsIds);
        return new PurgeReport(toDeleteScenariosExecutionsIds, toDeleteCampaignsExecutionsIds);
    }

    private Set<Long> getCampaignExecutionsToDelete(Set<Long> executionsIds) {
        return executionsIds.stream().map(this::getExecutionSummary).map(ExecutionHistory.ExecutionProperties::campaignReport).flatMap(Optional::stream).filter(campaignExecution -> campaignExecution.scenarioExecutionReports().size() == 1).map(campaignExecution -> campaignExecution.executionId).collect(Collectors.toSet());
    }

    private void updateExecutionsToKO(List<ExecutionHistory.ExecutionSummary> executions) {
        executions.stream().map(this::buildKnockoutExecutionFrom).forEach(this::update);
    }

    private ImmutableExecutionHistory.Execution buildKnockoutExecutionFrom(ExecutionHistory.ExecutionSummary executionSummary) {
        String reportStoppedRunningOrPausedStatus = this.stopRunningOrPausedReport(executionSummary);
        return ImmutableExecutionHistory.Execution.builder().executionId(executionSummary.executionId()).status(ServerReportStatus.FAILURE).time(executionSummary.time()).duration(executionSummary.duration()).info(executionSummary.info()).error("Execution was interrupted !").report(reportStoppedRunningOrPausedStatus).testCaseTitle(executionSummary.testCaseTitle()).environment(executionSummary.environment()).user(executionSummary.user()).scenarioId(executionSummary.scenarioId()).tags(executionSummary.tags()).build();
    }

    private String stopRunningOrPausedReport(ExecutionHistory.ExecutionSummary executionSummary) {
        return this.scenarioExecutionReportJpaRepository.findById(executionSummary.executionId()).map(ScenarioExecutionReportEntity::toDomain).map(execution -> {
            try {
                ScenarioExecutionReport newScenarioExecutionReport = this.updateStatusInScenarioExecutionReportWithStoppedStatusIfRunningOrPaused((ExecutionHistory.Execution)execution);
                return this.objectMapper.writeValueAsString((Object)newScenarioExecutionReport);
            }
            catch (JsonProcessingException exception) {
                LOGGER.error("Unexpected error while deserializing report for execution id " + executionSummary.executionId(), (Throwable)exception);
                return "";
            }
        }).orElseGet(() -> {
            LOGGER.warn("Report not found for execution id {}", (Object)executionSummary.executionId());
            return "";
        });
    }

    private ScenarioExecutionReport updateStatusInScenarioExecutionReportWithStoppedStatusIfRunningOrPaused(ExecutionHistory.Execution execution) throws JsonProcessingException {
        ScenarioExecutionReport scenarioExecutionReport = (ScenarioExecutionReport)this.objectMapper.readValue(execution.report(), ScenarioExecutionReport.class);
        StepExecutionReportCore report = this.updateStepWithStoppedStatusIfRunningOrPaused(scenarioExecutionReport.report);
        return this.updateScenarioExecutionReport(scenarioExecutionReport, report);
    }

    private ScenarioExecutionReport updateScenarioExecutionReport(ScenarioExecutionReport scenarioExecutionReport, StepExecutionReportCore report) {
        return new ScenarioExecutionReport(scenarioExecutionReport.executionId, scenarioExecutionReport.scenarioName, scenarioExecutionReport.environment, scenarioExecutionReport.user, (Collection)scenarioExecutionReport.tags, scenarioExecutionReport.datasetId, scenarioExecutionReport.constants, scenarioExecutionReport.datatable, report);
    }

    private List<StepExecutionReportCore> updateStepListWithStoppedStatusIfRunningOrPaused(List<StepExecutionReportCore> steps) {
        return steps.stream().map(this::updateStepWithStoppedStatusIfRunningOrPaused).collect(Collectors.toList());
    }

    private boolean isExecutionRunningOrPaused(ServerReportStatus status) {
        return status.equals((Object)ServerReportStatus.RUNNING) || status.equals((Object)ServerReportStatus.PAUSED);
    }

    private StepExecutionReportCore updateStepWithStoppedStatusIfRunningOrPaused(StepExecutionReportCore step) {
        ServerReportStatus status = this.isExecutionRunningOrPaused(step.status) ? ServerReportStatus.STOPPED : step.status;
        List<StepExecutionReportCore> steps = this.updateStepListWithStoppedStatusIfRunningOrPaused(step.steps);
        return new StepExecutionReportCore(step.name, step.duration, step.startDate, status, step.information, step.errors, steps, step.type, step.targetName, step.targetUrl, step.strategy, step.evaluatedInputs, step.stepOutputs);
    }

    private boolean invalidScenarioId(String scenarioId) {
        return Strings.isNullOrEmpty((String)scenarioId);
    }
}

