/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.infra.storage.index;

import fr.enedis.chutney.execution.infra.storage.jpa.ScenarioExecutionReportEntity;
import fr.enedis.chutney.index.api.dto.Hit;
import fr.enedis.chutney.index.infra.LuceneIndexRepository;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class ExecutionReportIndexRepository {
    private final String WHAT_VALUE = "executionReport";
    private final String WHAT = "what";
    private final String ID = "id";
    private final String REPORT = "report";
    private final LuceneIndexRepository luceneIndexRepository;

    public ExecutionReportIndexRepository(@Qualifier(value="reportLuceneIndexRepository") LuceneIndexRepository luceneIndexRepository) {
        this.luceneIndexRepository = luceneIndexRepository;
    }

    public void save(ScenarioExecutionReportEntity report) {
        Document document = new Document();
        document.add((IndexableField)new StringField("what", "executionReport", Field.Store.YES));
        document.add((IndexableField)new StringField("id", report.scenarioExecutionId().toString(), Field.Store.YES));
        document.add((IndexableField)new TextField("report", report.getReport().toLowerCase(), Field.Store.NO));
        this.luceneIndexRepository.index(document);
    }

    public void saveAll(List<ScenarioExecutionReportEntity> reports) {
        reports.forEach(this::save);
    }

    public void delete(Long scenarioExecutionId) {
        TermQuery whatQuery = new TermQuery(new Term("what", "executionReport"));
        TermQuery idQuery = new TermQuery(new Term("id", scenarioExecutionId.toString()));
        BooleanQuery query = new BooleanQuery.Builder().add((Query)idQuery, BooleanClause.Occur.MUST).add((Query)whatQuery, BooleanClause.Occur.MUST).build();
        this.luceneIndexRepository.delete((Query)query);
    }

    public void deleteAllById(Set<Long> scenarioExecutionIds) {
        scenarioExecutionIds.forEach(this::delete);
    }

    public List<Long> idsByKeywordInReport(String keyword) {
        return this.search(keyword).stream().map(Hit::id).map(Long::parseLong).toList();
    }

    private List<Hit> search(String keyword) {
        TermQuery whatQuery = new TermQuery(new Term("what", "executionReport"));
        WildcardQuery reportQuery = new WildcardQuery(new Term("report", "*" + keyword.toLowerCase() + "*"));
        BooleanQuery query = new BooleanQuery.Builder().add((Query)reportQuery, BooleanClause.Occur.MUST).add((Query)whatQuery, BooleanClause.Occur.MUST).build();
        return this.luceneIndexRepository.search((Query)query, 100).stream().map(doc -> new Hit(doc.get("id"), null, null, null, Collections.emptyList(), "executionReport")).toList();
    }

    public int count() {
        TermQuery whatQuery = new TermQuery(new Term("what", "executionReport"));
        return this.luceneIndexRepository.count((Query)whatQuery);
    }
}

