/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.index.domain;

import fr.enedis.chutney.index.api.dto.Hit;
import fr.enedis.chutney.index.domain.IndexRepository;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.springframework.stereotype.Service;

@Service
public class IndexService {
    private final List<IndexRepository<?>> indexRepositories;

    public IndexService(List<IndexRepository<?>> indexRepositories) {
        this.indexRepositories = indexRepositories;
    }

    public List<Hit> search(String query) {
        List<CompletableFuture> futures = this.indexRepositories.stream().map(repo -> CompletableFuture.supplyAsync(() -> repo.search(query))).toList();
        CompletableFuture<Void> allSearches = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return (List)((CompletableFuture)allSearches.thenApply(v -> futures.stream().flatMap(future -> {
            try {
                return ((List)future.get()).stream();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }).toList())).join();
    }
}

