/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.index.infra;

import fr.enedis.chutney.index.infra.config.IndexConfig;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexRepository {
    private final IndexWriter indexWriter;
    private final Directory indexDirectory;
    private final Analyzer analyzer;
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneIndexRepository.class);

    public LuceneIndexRepository(IndexConfig config) {
        this.indexDirectory = config.directory();
        this.indexWriter = config.indexWriter();
        this.analyzer = config.analyzer();
    }

    public void index(Document document) {
        try {
            this.indexWriter.addDocument((Iterable)document);
            this.indexWriter.commit();
        }
        catch (Exception e) {
            LOGGER.error("Couldn't index data", (Throwable)e);
        }
    }

    public void update(Query query, Document document) {
        try {
            this.indexWriter.updateDocuments(query, List.of(document));
            this.indexWriter.commit();
        }
        catch (Exception e) {
            LOGGER.error("Couldn't index data", (Throwable)e);
        }
    }

    public List<Document> search(Query query, int limit) {
        ArrayList<Document> result = new ArrayList<Document>();
        try (DirectoryReader reader = DirectoryReader.open((Directory)this.indexDirectory);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            ScoreDoc[] hits = searcher.search((Query)query, (int)limit).scoreDocs;
            StoredFields storedFields = searcher.storedFields();
            for (ScoreDoc hit : hits) {
                result.add(storedFields.document(hit.doc));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public int count(Query query) {
        int n;
        block8: {
            DirectoryReader reader = DirectoryReader.open((Directory)this.indexDirectory);
            try {
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                n = searcher.count(query);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Couldn't count elements in index", (Throwable)e);
                    return 0;
                }
            }
            reader.close();
        }
        return n;
    }

    public void delete(Query query) {
        try {
            this.indexWriter.deleteDocuments(new Query[]{query});
            this.indexWriter.commit();
        }
        catch (IOException e) {
            LOGGER.error("Couldn't delete index using query " + String.valueOf(query), (Throwable)e);
        }
    }

    public void deleteAll() {
        try {
            this.indexWriter.deleteAll();
            this.indexWriter.commit();
        }
        catch (Exception e) {
            LOGGER.error("Couldn't delete all indexes", (Throwable)e);
        }
    }

    public String highlight(List<String> keywords, String field, String value, boolean strict) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Query query = this.createCombinedWildcardQuery(keywords, field);
        Highlighter highlighter = this.createHighlighter(query);
        return this.processHighlight(highlighter, field, value, strict);
    }

    private Query createCombinedWildcardQuery(List<String> keywords, String field) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (String keyword : keywords) {
            builder.add((Query)new WildcardQuery(new Term(field, "*" + QueryParser.escape((String)keyword) + "*")), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    private Highlighter createHighlighter(Query query) {
        QueryScorer scorer = new QueryScorer(query);
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter("<mark>", "</mark>");
        return new Highlighter((Formatter)formatter, (Scorer)scorer);
    }

    private String processHighlight(Highlighter highlighter, String fieldName, String text, boolean strict) {
        String string;
        block9: {
            TokenStream tokenStream = this.analyzer.tokenStream(fieldName, (Reader)new StringReader(text));
            try {
                String highlightedText = highlighter.getBestFragment(tokenStream, text);
                String string2 = highlightedText != null ? highlightedText : (string = strict ? null : text);
                if (tokenStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (tokenStream != null) {
                        try {
                            tokenStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InvalidTokenOffsetsException e) {
                    LOGGER.warn("Unable to highlight {} field: {}", (Object)fieldName, (Object)e);
                    return text;
                }
                catch (RuntimeException e) {
                    LOGGER.error("processHighlight error", (Throwable)e);
                    return "";
                }
            }
            tokenStream.close();
        }
        return string;
    }
}

