/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.migration.domain;

import fr.enedis.chutney.migration.domain.DataMigrator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;

public abstract class AbstractMigrator<T>
implements DataMigrator {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @Override
    public void migrate() {
        if (this.isMigrationDone()) {
            this.LOGGER.info("{} index not empty. Skipping indexing...", (Object)this.getEntityName());
            return;
        }
        this.LOGGER.info("Start indexing {}...", (Object)this.getEntityName());
        PageRequest firstPage = PageRequest.of((int)0, (int)10);
        int count = 0;
        this.migrate((Pageable)firstPage, count);
    }

    protected void migrate(Pageable pageable, int previousCount) {
        this.LOGGER.debug("Indexing page n\u00b0 {}", (Object)pageable.getPageNumber());
        Slice<T> slice = this.findAll(pageable);
        List entities = slice.getContent();
        this.index(entities);
        int count = previousCount + slice.getNumberOfElements();
        if (slice.hasNext()) {
            this.migrate(slice.nextPageable(), count);
        } else {
            this.LOGGER.info("{} {} successfully indexed", (Object)count, (Object)this.getEntityName());
        }
    }

    protected abstract Slice<T> findAll(Pageable var1);

    protected abstract void index(List<T> var1);

    protected abstract boolean isMigrationDone();

    protected abstract String getEntityName();
}

