/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.migration.domain;

import fr.enedis.chutney.dataset.infra.FileDatasetRepository;
import fr.enedis.chutney.dataset.infra.index.DatasetIndexRepository;
import fr.enedis.chutney.migration.domain.DataMigrator;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DatasetMigrator
implements DataMigrator {
    private final FileDatasetRepository datasetRepository;
    private final DatasetIndexRepository datasetIndexRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetMigrator.class);

    public DatasetMigrator(FileDatasetRepository datasetRepository, DatasetIndexRepository datasetIndexRepository) {
        this.datasetRepository = datasetRepository;
        this.datasetIndexRepository = datasetIndexRepository;
    }

    @Override
    public void migrate() {
        if (this.isMigrationDone()) {
            LOGGER.info("Dataset index not empty. Skipping indexing...");
            return;
        }
        LOGGER.info("Start indexing...");
        List<DataSet> dataSets = this.datasetRepository.findAll();
        this.index(dataSets);
        LOGGER.info("{} dataset(s) successfully indexed", (Object)dataSets.size());
    }

    private void index(List<DataSet> dataSets) {
        this.datasetIndexRepository.saveAll(dataSets);
    }

    private boolean isMigrationDone() {
        int indexedReports = this.datasetIndexRepository.count();
        return indexedReports > 0;
    }
}

