/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.scenario.api;

import fr.enedis.chutney.execution.api.ExecutionSummaryDto;
import fr.enedis.chutney.scenario.api.raw.dto.TestCaseIndexDto;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistory;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistoryRepository;
import fr.enedis.chutney.server.core.domain.scenario.ScenarioNotFoundException;
import fr.enedis.chutney.server.core.domain.scenario.TestCase;
import fr.enedis.chutney.server.core.domain.scenario.TestCaseMetadata;
import fr.enedis.chutney.server.core.domain.scenario.TestCaseRepository;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/scenario/v2"})
public class AggregatedTestCaseController {
    private final TestCaseRepository testCaseRepository;
    private final ExecutionHistoryRepository executionHistoryRepository;

    public AggregatedTestCaseController(TestCaseRepository testCaseRepository, ExecutionHistoryRepository executionHistoryRepository) {
        this.testCaseRepository = testCaseRepository;
        this.executionHistoryRepository = executionHistoryRepository;
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/{testCaseId}/metadata"}, produces={"application/json"})
    public TestCaseIndexDto testCaseMetaData(@PathVariable(value="testCaseId") String testCaseId) {
        TestCase testCase = (TestCase)this.testCaseRepository.findById(testCaseId).orElseThrow(() -> new ScenarioNotFoundException(testCaseId));
        return TestCaseIndexDto.from(testCase.metadata());
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ') or hasAuthority('CAMPAIGN_WRITE')")
    @GetMapping(path={""}, produces={"application/json"})
    public List<TestCaseIndexDto> getTestCases() {
        List testCases = this.testCaseRepository.findAll();
        Map lastExecutions = this.executionHistoryRepository.getLastExecutions(testCases.stream().map(TestCaseMetadata::id).collect(Collectors.toList()));
        return testCases.stream().map(tc -> {
            if (lastExecutions.get(tc.id()) != null) {
                ExecutionSummaryDto execution = ExecutionSummaryDto.toDto((ExecutionHistory.ExecutionSummary)lastExecutions.get(tc.id()));
                return TestCaseIndexDto.from(tc, execution);
            }
            return TestCaseIndexDto.from(tc);
        }).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_WRITE')")
    @DeleteMapping(path={"/{testCaseId}"})
    public void removeScenarioById(@PathVariable(value="testCaseId") String testCaseId) {
        this.testCaseRepository.removeById(testCaseId);
    }
}

