/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.scenario.infra.raw;

import com.google.common.base.Strings;
import fr.enedis.chutney.campaign.infra.CampaignScenarioJpaRepository;
import fr.enedis.chutney.campaign.infra.jpa.CampaignScenarioEntity;
import fr.enedis.chutney.execution.infra.storage.DatabaseExecutionJpaRepository;
import fr.enedis.chutney.execution.infra.storage.jpa.ScenarioExecutionEntity;
import fr.enedis.chutney.scenario.domain.gwt.GwtTestCase;
import fr.enedis.chutney.scenario.infra.jpa.ScenarioEntity;
import fr.enedis.chutney.scenario.infra.raw.ScenarioJpaRepository;
import fr.enedis.chutney.server.core.domain.scenario.AggregatedRepository;
import fr.enedis.chutney.server.core.domain.scenario.ScenarioNotFoundException;
import fr.enedis.chutney.server.core.domain.scenario.ScenarioNotParsableException;
import fr.enedis.chutney.server.core.domain.scenario.TestCase;
import fr.enedis.chutney.server.core.domain.scenario.TestCaseMetadata;
import jakarta.persistence.EntityManager;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class DatabaseTestCaseRepository
implements AggregatedRepository<GwtTestCase> {
    private final ScenarioJpaRepository scenarioJpaRepository;
    private final DatabaseExecutionJpaRepository scenarioExecutionsJpaRepository;
    private final CampaignScenarioJpaRepository campaignScenarioJpaRepository;

    public DatabaseTestCaseRepository(ScenarioJpaRepository jpa, DatabaseExecutionJpaRepository scenarioExecutionsJpaRepository, CampaignScenarioJpaRepository campaignScenarioJpaRepository, EntityManager entityManager) {
        this.scenarioJpaRepository = jpa;
        this.scenarioExecutionsJpaRepository = scenarioExecutionsJpaRepository;
        this.campaignScenarioJpaRepository = campaignScenarioJpaRepository;
    }

    @Transactional
    public String save(GwtTestCase testCase) {
        if (this.scenarioWithExplicitIdNotExists(testCase)) {
            this.saveScenarioWithExplicitId(testCase);
            return testCase.id();
        }
        try {
            return ((ScenarioEntity)this.scenarioJpaRepository.save(ScenarioEntity.fromGwtTestCase(testCase))).getId().toString();
        }
        catch (ObjectOptimisticLockingFailureException e) {
            throw new ScenarioNotFoundException(testCase.id(), testCase.metadata().version());
        }
    }

    private boolean scenarioWithExplicitIdNotExists(TestCase testCase) {
        String testCaseId = testCase.id();
        try {
            return testCaseId != null && !this.scenarioJpaRepository.existsById(Long.parseLong(testCaseId));
        }
        catch (NumberFormatException e) {
            throw new ScenarioNotParsableException("Cannot parse id", (Exception)e);
        }
    }

    public Optional<GwtTestCase> findById(String scenarioId) {
        if (this.checkIdInput(scenarioId)) {
            return Optional.empty();
        }
        Optional<ScenarioEntity> scenarioDao = this.scenarioJpaRepository.findByIdAndActivated(Long.valueOf(scenarioId), true).filter(ScenarioEntity::isActivated);
        return scenarioDao.map(ScenarioEntity::toGwtTestCase);
    }

    public Optional<TestCase> findExecutableById(String id) {
        return this.findById(id).map(TestCase.class::cast);
    }

    public Optional<TestCaseMetadata> findMetadataById(String testCaseId) {
        if (this.checkIdInput(testCaseId)) {
            return Optional.empty();
        }
        return this.scenarioJpaRepository.findMetaDataByIdAndActivated(Long.valueOf(testCaseId), true).map(ScenarioEntity::toTestCaseMetadata);
    }

    public List<TestCaseMetadata> findAll() {
        return this.scenarioJpaRepository.findMetaDataByActivatedTrue().stream().map(ScenarioEntity::toTestCaseMetadata).toList();
    }

    public List<TestCaseMetadata> findAllByDatasetId(String datasetId) {
        return this.scenarioJpaRepository.findByActivatedTrueAndDefaultDataset(datasetId).stream().map(ScenarioEntity::toTestCaseMetadata).toList();
    }

    @Transactional
    public void removeById(String scenarioId) {
        if (this.checkIdInput(scenarioId)) {
            return;
        }
        this.scenarioJpaRepository.findByIdAndActivated(Long.valueOf(scenarioId), true).ifPresent(scenarioJpa -> {
            List<ScenarioExecutionEntity> allExecutions = this.scenarioExecutionsJpaRepository.findAllByScenarioId(scenarioId);
            allExecutions.forEach(e -> {
                e.forCampaignExecution(null);
                this.scenarioExecutionsJpaRepository.save(e);
            });
            List<CampaignScenarioEntity> allCampaignScenarioEntities = this.campaignScenarioJpaRepository.findAllByScenarioId(scenarioId);
            this.campaignScenarioJpaRepository.deleteAll(allCampaignScenarioEntities);
            scenarioJpa.deactivate();
            this.scenarioJpaRepository.save(scenarioJpa);
        });
    }

    public Optional<Integer> lastVersion(String scenarioId) {
        if (this.checkIdInput(scenarioId)) {
            return Optional.empty();
        }
        try {
            return this.scenarioJpaRepository.lastVersion(Long.valueOf(scenarioId));
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return Optional.empty();
        }
    }

    private void saveScenarioWithExplicitId(GwtTestCase testCase) {
        ScenarioEntity scenarioEntity = ScenarioEntity.fromGwtTestCase(testCase);
        this.scenarioJpaRepository.saveWithExplicitId(scenarioEntity.getId(), scenarioEntity.getTitle(), scenarioEntity.getDescription(), scenarioEntity.getContent(), scenarioEntity.getTags(), scenarioEntity.getCreationDate(), scenarioEntity.isActivated(), scenarioEntity.getUserId(), scenarioEntity.getUpdateDate(), scenarioEntity.getVersion(), scenarioEntity.getDefaultDataset());
    }

    private boolean checkIdInput(String scenarioId) {
        return Strings.isNullOrEmpty((String)scenarioId) || !StringUtils.isNumeric((CharSequence)scenarioId);
    }
}

