/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.scenario.infra.raw;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class TagListMapper {
    private static final String TAGS_SEPARATOR = ",";
    public static final String TAGS_SPLIT_REG_EX = "\\s*,\\s*";

    public static List<String> tagsStringToList(String tags) {
        return Stream.of(TagListMapper.splitTagsString(tags)).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
    }

    public static Set<String> tagsStringToSet(String tags) {
        return Stream.of(TagListMapper.splitTagsString(tags)).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toSet());
    }

    public static String tagsToString(Collection<String> tags) {
        return Optional.ofNullable(tags).stream().flatMap(Collection::stream).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.joining(TAGS_SEPARATOR));
    }

    private static String[] splitTagsString(String tags) {
        return Optional.ofNullable(tags).orElse("").split(TAGS_SPLIT_REG_EX);
    }
}

