/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.security;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import fr.enedis.chutney.security.infra.jwt.JwtUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class HttpLoginSuccessHandler
implements AuthenticationSuccessHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpLoginSuccessHandler.class);
    private final JwtUtil jwtUtil;
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    public HttpLoginSuccessHandler(JwtUtil jwtUtil) {
        this.jwtUtil = jwtUtil;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        LOGGER.info("User {} logged in", (Object)authentication.getName());
        if (!authentication.isAuthenticated()) {
            LOGGER.debug("Authentication failure for user [{}]", authentication.getPrincipal());
            response.sendError(HttpStatus.UNAUTHORIZED.value(), "Authentication failed");
            return;
        }
        LOGGER.info("User {} logged in", (Object)authentication.getName());
        Map claims = (Map)this.objectMapper.convertValue(authentication.getPrincipal(), Map.class);
        String token = this.jwtUtil.generateToken(authentication.getName(), claims);
        Map<String, String> tokenMap = Collections.singletonMap("token", token);
        response.setContentType("application/json");
        response.setStatus(HttpStatus.OK.value());
        this.objectMapper.writeValue((OutputStream)response.getOutputStream(), tokenMap);
    }
}

