/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.security.api;

import fr.enedis.chutney.security.api.AuthorizationsDto;
import fr.enedis.chutney.server.core.domain.security.Role;
import fr.enedis.chutney.server.core.domain.security.User;
import fr.enedis.chutney.server.core.domain.security.UserRoles;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public final class AuthorizationMapper {
    public static AuthorizationsDto toDto(UserRoles userRoles) {
        AuthorizationsDto dto = new AuthorizationsDto();
        dto.setRoles(userRoles.roles().stream().map(AuthorizationMapper::roleToDto).collect(Collectors.toList()));
        dto.setAuthorizations(AuthorizationMapper.userRolesToDto(userRoles));
        return dto;
    }

    public static UserRoles fromDto(AuthorizationsDto dto) {
        List roles = dto.getRoles().stream().map(AuthorizationMapper::roleFromDto).collect(Collectors.toList());
        List users = dto.getAuthorizations().stream().flatMap(AuthorizationMapper::usersFromDto).collect(Collectors.toList());
        return UserRoles.builder().withRoles(roles).withUsers(users).build();
    }

    private static AuthorizationsDto.RoleDto roleToDto(Role role) {
        AuthorizationsDto.RoleDto dto = new AuthorizationsDto.RoleDto();
        dto.setName(role.name);
        dto.setRights(role.authorizations.stream().map(Enum::name).collect(Collectors.toList()));
        return dto;
    }

    private static List<AuthorizationsDto.RoleUsersDto> userRolesToDto(UserRoles userRoles) {
        return userRoles.roles().stream().map(r -> Pair.of((Object)r, userRoles.usersByRole(r).stream().map(u -> u.id).collect(Collectors.toList()))).filter(p -> !((List)p.getRight()).isEmpty()).map(p -> {
            AuthorizationsDto.RoleUsersDto dto = new AuthorizationsDto.RoleUsersDto();
            dto.setName(((Role)p.getLeft()).name);
            dto.setUsers((List)p.getRight());
            return dto;
        }).collect(Collectors.toList());
    }

    private static Role roleFromDto(AuthorizationsDto.RoleDto roleDto) {
        return Role.builder().withName(roleDto.getName()).withAuthorizations(roleDto.getRights()).build();
    }

    private static Stream<User> usersFromDto(AuthorizationsDto.RoleUsersDto roleUsersDto) {
        return roleUsersDto.getUsers().stream().map(id -> User.builder().withId(id).withRole(roleUsersDto.getName()).build());
    }
}

