/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.security.infra.sso;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import fr.enedis.chutney.security.api.UserDto;
import fr.enedis.chutney.security.domain.AuthenticationService;
import fr.enedis.chutney.security.infra.UserDetailsServiceHelper;
import fr.enedis.chutney.security.infra.jwt.JwtUtil;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.web.filter.OncePerRequestFilter;

public class OAuth2TokenAuthenticationFilter
extends OncePerRequestFilter {
    private final JwtUtil jwtUtil;
    private final AuthenticationService authenticationService;
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    public OAuth2TokenAuthenticationFilter(JwtUtil jwtUtil, AuthenticationService authenticationService) {
        this.jwtUtil = jwtUtil;
        this.authenticationService = authenticationService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof OAuth2IntrospectionAuthenticatedPrincipal) {
            String username = (String)((OAuth2IntrospectionAuthenticatedPrincipal)authentication.getPrincipal()).getAttributes().get("sub");
            UserDto user = new UserDto();
            user.setId(username);
            user.setName(username);
            user.setMail(username);
            user.setFirstname(username);
            user.setLastname(username);
            user.setRoles(Collections.emptySet());
            user = UserDetailsServiceHelper.grantAuthoritiesFromUserRole(user, this.authenticationService);
            Map claims = (Map)this.objectMapper.convertValue((Object)user, Map.class);
            response.addHeader("X-Custom-Token", this.jwtUtil.generateToken(authentication.getName(), claims));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

