
package fr.enedis.chutney.dataset.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link KeyValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableKeyValue.builder()}.
 */
@Generated(from = "KeyValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableKeyValue implements KeyValue {
  private final String key;
  private final String value;

  private ImmutableKeyValue(ImmutableKeyValue.Builder builder) {
    this.key = builder.key;
    this.value = builder.value != null
        ? builder.value
        : Objects.requireNonNull(KeyValue.super.value(), "value");
  }

  private ImmutableKeyValue(String key, String value) {
    this.key = key;
    this.value = value;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty(value = "key", required = true)
  @Override
  public String key() {
    return key;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty(value = "value", required = true)
  @Override
  public String value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyValue#key() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableKeyValue withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (this.key.equals(newValue)) return this;
    return new ImmutableKeyValue(newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyValue#value() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableKeyValue withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableKeyValue(this.key, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableKeyValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableKeyValue
        && equalsByValue((ImmutableKeyValue) another);
  }

  private boolean equalsByValue(ImmutableKeyValue another) {
    return key.equals(another.key)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code KeyValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "KeyValue{"
        + "key=" + key
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "KeyValue", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  static final class Json implements KeyValue {
    @JsonIgnore @Nullable String key;
    @JsonIgnore @Nullable String value;

    @JsonProperty(value = "key", required = true)
    public void setKey(String key) {
      this.key = key;
    }

    @JsonProperty(value = "value", required = true)
    public void setValue(String value) {
      this.value = value;
    }

    @Override
    public String key() { throw new UnsupportedOperationException(); }

    @Override
    public String value() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableKeyValue fromJson(Json json) {
    ImmutableKeyValue.Builder builder = ImmutableKeyValue.builder();
    if (json.key != null) {
      builder.key(json.key);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link KeyValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable KeyValue instance
   */
  public static ImmutableKeyValue copyOf(KeyValue instance) {
    if (instance instanceof ImmutableKeyValue) {
      return (ImmutableKeyValue) instance;
    }
    return ImmutableKeyValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableKeyValue ImmutableKeyValue}.
   * <pre>
   * ImmutableKeyValue.builder()
   *    .key(String) // required {@link KeyValue#key() key}
   *    .value(String) // optional {@link KeyValue#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableKeyValue builder
   */
  public static ImmutableKeyValue.Builder builder() {
    return new ImmutableKeyValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableKeyValue ImmutableKeyValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "KeyValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String key;
    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code KeyValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(KeyValue instance) {
      Objects.requireNonNull(instance, "instance");
      this.key(instance.key());
      this.value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link KeyValue#key() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "key", required = true)
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link KeyValue#value() value} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link KeyValue#value() value}.</em>
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty(value = "value", required = true)
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      return this;
    }

    /**
     * Builds a new {@link ImmutableKeyValue ImmutableKeyValue}.
     * @return An immutable instance of KeyValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableKeyValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableKeyValue(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      return "Cannot build KeyValue, some of required attributes are not set " + attributes;
    }
  }
}
