/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney;

import fr.enedis.chutney.ServerConfiguration;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistoryRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.boot.Banner;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;

public class ServerBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerBootstrap.class);

    public static void main(String ... args) {
        ServerBootstrap.setUpJULSL4JBridge();
        ConfigurableApplicationContext context = ServerBootstrap.start(args);
        ServerBootstrap.cleanApplicationState(context);
    }

    private static void setUpJULSL4JBridge() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    public static ConfigurableApplicationContext start(String ... args) {
        SpringApplicationBuilder appBuilder = new SpringApplicationBuilder(new Class[]{ServerConfiguration.class}).registerShutdownHook(true).bannerMode(Banner.Mode.OFF);
        return appBuilder.build().run(args);
    }

    private static void cleanApplicationState(ConfigurableApplicationContext context) {
        int staleExecutionCount = ((ExecutionHistoryRepository)context.getBean(ExecutionHistoryRepository.class)).setAllRunningExecutionsToKO();
        LOGGER.info("Starting with " + staleExecutionCount + " unfinished executions");
    }
}

