/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.admin.api;

import fr.enedis.chutney.admin.domain.DBVacuum;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/admin/database"})
public class DatabaseManagementController {
    private final DBVacuum dbVacuum;

    DatabaseManagementController(DBVacuum dbVacuum) {
        this.dbVacuum = dbVacuum;
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @PostMapping(path={"/compact"}, produces={"application/json"})
    public List<Long> vacuum() {
        DBVacuum.VacuumReport report = this.dbVacuum.vacuum();
        return List.of(report.beforeSize(), report.afterSize());
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @GetMapping(path={"/size"}, produces={"application/json"})
    public Long dbSize() {
        return this.dbVacuum.size();
    }
}

