/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.agent.api.mapper;

import fr.enedis.chutney.agent.api.dto.NetworkConfigurationApiDto;
import fr.enedis.chutney.environment.api.environment.dto.EnvironmentDto;
import fr.enedis.chutney.environment.api.target.dto.TargetDto;
import fr.enedis.chutney.tools.Entry;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentApiMapper {
    public EnvironmentDto fromDto(NetworkConfigurationApiDto.EnvironmentApiDto environmentApiDto) {
        List targets = environmentApiDto.targetsConfiguration.stream().map(this::fromDto).collect(Collectors.toList());
        return new EnvironmentDto(environmentApiDto.name, null, targets);
    }

    private TargetDto fromDto(NetworkConfigurationApiDto.TargetsApiDto targetsApiDto) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(targetsApiDto.properties);
        return new TargetDto(targetsApiDto.name, targetsApiDto.url, Entry.toEntrySet(properties));
    }

    public NetworkConfigurationApiDto.EnvironmentApiDto toDto(EnvironmentDto environment) {
        return new NetworkConfigurationApiDto.EnvironmentApiDto(environment.name, environment.targets.stream().map(this::toDto).collect(Collectors.toSet()));
    }

    private NetworkConfigurationApiDto.TargetsApiDto toDto(TargetDto target) {
        Map properties = Entry.toMap((Collection)target.properties);
        return new NetworkConfigurationApiDto.TargetsApiDto(target.name, target.url, properties);
    }
}

