/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.agent.api.mapper;

import fr.enedis.chutney.agent.api.dto.ExploreResultApiDto;
import fr.enedis.chutney.agent.api.dto.TargetIdEntity;
import fr.enedis.chutney.agent.domain.TargetId;
import fr.enedis.chutney.agent.domain.explore.AgentId;
import fr.enedis.chutney.agent.domain.explore.ExploreResult;
import fr.enedis.chutney.agent.domain.explore.ImmutableExploreResult;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ExploreResultApiMapper {
    public ExploreResult fromDto(ExploreResultApiDto linksEntity, ExploreResultApiDto.AgentLinkEntity linkToExploredAgent) {
        return ImmutableExploreResult.builder().agentLinks(ImmutableExploreResult.Links.builder().addAllLinks(linksEntity.agentLinks.stream().map(linkEntity -> ImmutableExploreResult.Link.of(AgentId.of(linkEntity.source), AgentId.of(linkEntity.destination))).collect(Collectors.toSet())).addLinks((ExploreResult.Link<AgentId, AgentId>)ImmutableExploreResult.Link.of(AgentId.of(linkToExploredAgent.source), AgentId.of(linkToExploredAgent.destination))).build()).targetLinks(ImmutableExploreResult.Links.of(linksEntity.targetLinks.stream().map(targetLinkEntity -> ImmutableExploreResult.Link.of(AgentId.of(targetLinkEntity.source), this.from((ExploreResultApiDto.TargetLinkEntity)targetLinkEntity))).collect(Collectors.toSet()))).build();
    }

    private TargetId from(ExploreResultApiDto.TargetLinkEntity targetLinkEntity) {
        return TargetId.of(targetLinkEntity.destination.name, targetLinkEntity.destination.environment);
    }

    public ExploreResultApiDto from(ExploreResult exploreResult) {
        ExploreResultApiDto dto = new ExploreResultApiDto();
        dto.agentLinks = exploreResult.agentLinks().stream().map(link -> new ExploreResultApiDto.AgentLinkEntity(((AgentId)link.source()).name(), ((AgentId)link.destination()).name())).collect(Collectors.toSet());
        dto.targetLinks.addAll(exploreResult.targetLinks().stream().map(link -> new ExploreResultApiDto.TargetLinkEntity(((AgentId)link.source()).name(), this.from((TargetId)link.destination()))).collect(Collectors.toSet()));
        return dto;
    }

    private TargetIdEntity from(TargetId destination) {
        return new TargetIdEntity(destination.name, destination.environment);
    }
}

