/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.agent.api.mapper;

import fr.enedis.chutney.agent.api.dto.NetworkConfigurationApiDto;
import fr.enedis.chutney.agent.api.mapper.AgentInfoApiMapper;
import fr.enedis.chutney.agent.api.mapper.EnvironmentApiMapper;
import fr.enedis.chutney.agent.domain.configure.ImmutableNetworkConfiguration;
import fr.enedis.chutney.agent.domain.configure.NetworkConfiguration;
import fr.enedis.chutney.environment.api.environment.dto.EnvironmentDto;
import java.time.Instant;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class NetworkConfigurationApiMapper {
    private final AgentInfoApiMapper agentInfoMapper;
    private final EnvironmentApiMapper targetApiMapper;

    public NetworkConfigurationApiMapper(AgentInfoApiMapper agentInfoMapper, EnvironmentApiMapper targetApiMapper) {
        this.agentInfoMapper = agentInfoMapper;
        this.targetApiMapper = targetApiMapper;
    }

    public NetworkConfigurationApiDto toDto(NetworkConfiguration networkConfiguration) {
        NetworkConfigurationApiDto dto = new NetworkConfigurationApiDto();
        dto.creationDate = networkConfiguration.creationDate();
        dto.agentNetworkConfiguration = networkConfiguration.agentNetworkConfiguration().agentInfos().stream().map(this.agentInfoMapper::toDto).collect(Collectors.toSet());
        dto.environmentsConfiguration = networkConfiguration.environmentConfiguration().stream().map(this.targetApiMapper::toDto).collect(Collectors.toSet());
        return dto;
    }

    public NetworkConfiguration fromDto(NetworkConfigurationApiDto dto) {
        return this.fromDtoAt(dto, dto.creationDate);
    }

    public NetworkConfiguration fromDtoAtNow(NetworkConfigurationApiDto dto) {
        return this.fromDtoAt(dto, Instant.now());
    }

    private NetworkConfiguration fromDtoAt(NetworkConfigurationApiDto entity, Instant creation) {
        return ImmutableNetworkConfiguration.builder().agentNetworkConfiguration(ImmutableNetworkConfiguration.AgentNetworkConfiguration.builder().agentInfos(entity.agentNetworkConfiguration.stream().map(this.agentInfoMapper::fromDto).collect(Collectors.toSet())).build()).environmentConfiguration(ImmutableNetworkConfiguration.EnvironmentConfiguration.builder().environments(entity.environmentsConfiguration.stream().map(this.targetApiMapper::fromDto).collect(Collectors.toSet())).build()).creationDate(creation).build();
    }

    public NetworkConfiguration enhanceWithEnvironment(NetworkConfiguration networkConfiguration, Set<EnvironmentDto> localEnvironments) {
        return ImmutableNetworkConfiguration.builder().from(networkConfiguration).environmentConfiguration(ImmutableNetworkConfiguration.EnvironmentConfiguration.builder().addAllEnvironments(localEnvironments).build()).build();
    }
}

