/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.agent.api.mapper;

import fr.enedis.chutney.agent.api.dto.NetworkDescriptionApiDto;
import fr.enedis.chutney.agent.api.mapper.AgentGraphApiMapper;
import fr.enedis.chutney.agent.api.mapper.NetworkConfigurationApiMapper;
import fr.enedis.chutney.agent.domain.network.ImmutableNetworkDescription;
import fr.enedis.chutney.agent.domain.network.NetworkDescription;
import org.springframework.stereotype.Component;

@Component
public class NetworkDescriptionApiMapper {
    private final NetworkConfigurationApiMapper networkConfigurationMapper;
    private final AgentGraphApiMapper agentGraphMapper;

    public NetworkDescriptionApiMapper(NetworkConfigurationApiMapper networkConfigurationMapper, AgentGraphApiMapper agentGraphMapper) {
        this.networkConfigurationMapper = networkConfigurationMapper;
        this.agentGraphMapper = agentGraphMapper;
    }

    public NetworkDescriptionApiDto toDto(NetworkDescription networkDescription) {
        NetworkDescriptionApiDto networkDescriptionApiDto = new NetworkDescriptionApiDto();
        networkDescriptionApiDto.agentsGraph = this.agentGraphMapper.toDto(networkDescription.agentGraph());
        networkDescriptionApiDto.networkConfiguration = this.networkConfigurationMapper.toDto(networkDescription.configuration());
        return networkDescriptionApiDto;
    }

    public NetworkDescription fromDto(NetworkDescriptionApiDto networkDescriptionApiDto) {
        return ImmutableNetworkDescription.builder().agentGraph(this.agentGraphMapper.fromDto(networkDescriptionApiDto.agentsGraph)).configuration(this.networkConfigurationMapper.fromDto(networkDescriptionApiDto.networkConfiguration)).build();
    }
}

