/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.agent.domain.network;

import com.google.common.collect.Sets;
import fr.enedis.chutney.agent.domain.TargetId;
import fr.enedis.chutney.engine.domain.delegation.NamedHostAndPort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Agent {
    private static final Logger LOGGER = LoggerFactory.getLogger(Agent.class);
    public final NamedHostAndPort agentInfo;
    private final Set<Agent> reachableAgents = new LinkedHashSet<Agent>();
    private final Set<TargetId> reachableTargets = new LinkedHashSet<TargetId>();

    public Agent(NamedHostAndPort agentInfo) {
        this.agentInfo = agentInfo;
    }

    public Agent addReachable(Agent agent) {
        this.reachableAgents.add(agent);
        return this;
    }

    public Set<Agent> reachableAgents() {
        return new LinkedHashSet<Agent>(this.reachableAgents);
    }

    public Agent addReachable(TargetId target) {
        this.reachableTargets.add(target);
        return this;
    }

    public Set<TargetId> reachableTargets() {
        return new LinkedHashSet<TargetId>(this.reachableTargets);
    }

    public List<Agent> findFellowAgentForReaching(String targetName, String environment) {
        ArrayList<Agent> result = new ArrayList<Agent>();
        Optional<Agent> resultFound = this.findNext(this, TargetId.of(targetName, environment), Sets.newHashSet((Object[])new Agent[]{this}), result);
        if (resultFound.isPresent()) {
            Collections.reverse(result);
            return result;
        }
        return Collections.emptyList();
    }

    private Optional<Agent> findNext(Agent agent, TargetId target, Set<Agent> scannedAgents, List<Agent> accumulator) {
        if (agent.reachableTargets().contains(target)) {
            LOGGER.debug("Target reachable by agent " + agent.agentInfo.name());
            return Optional.of(agent);
        }
        LOGGER.debug("Target NOT reachable by agent " + agent.agentInfo.name());
        scannedAgents.add(agent);
        Optional<Agent> agentFound = agent.reachableAgents.stream().filter(nextAgent -> !scannedAgents.contains(nextAgent)).filter(nextAgent -> this.findNext((Agent)nextAgent, target, Sets.newHashSet((Iterable)scannedAgents), accumulator).isPresent()).findFirst();
        if (agentFound.isPresent()) {
            LOGGER.debug("Next Agent found " + agentFound.get().agentInfo.name());
            accumulator.add(agentFound.get());
        } else {
            LOGGER.debug("No next agent found. Will try to execute with local agent.");
        }
        return agentFound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Agent agent = (Agent)o;
        return Objects.equals(this.agentInfo, agent.agentInfo);
    }

    public int hashCode() {
        return Objects.hash(this.agentInfo);
    }

    public String toString() {
        return "Agent: " + this.agentInfo.toString();
    }
}

