/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.agent.domain.network;

import fr.enedis.chutney.agent.domain.TargetId;
import fr.enedis.chutney.agent.domain.configure.NetworkConfiguration;
import fr.enedis.chutney.agent.domain.explore.AgentId;
import fr.enedis.chutney.agent.domain.explore.ExploreResult;
import fr.enedis.chutney.agent.domain.network.Agent;
import fr.enedis.chutney.environment.api.target.dto.TargetDto;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class AgentGraph {
    private final Set<Agent> agents;

    public static AgentGraph of(ExploreResult exploreResult, NetworkConfiguration networkConfiguration) {
        Map<String, Agent> agentsByName = AgentGraph.indexAgents(networkConfiguration, agent -> agent.agentInfo.name());
        Map<String, Agent> agentsByHost = AgentGraph.indexAgents(networkConfiguration, agent -> agent.agentInfo.host());
        for (ExploreResult.Link<AgentId, AgentId> link : exploreResult.agentLinks()) {
            Agent agent2 = AgentGraph.searchInConfiguration(agentsByName, agentsByHost, link.source());
            Agent destAgent = AgentGraph.searchInConfiguration(agentsByName, agentsByHost, link.destination());
            if (agent2 == null) {
                throw new IllegalStateException(String.format("the agent [%s] is declared as source but does not exist in configuration", link.source()));
            }
            if (destAgent == null) {
                throw new IllegalStateException(String.format("the agent [%s] is declared as destination but does not exist in configuration", link.destination()));
            }
            agent2.addReachable(destAgent);
        }
        Map targetById = networkConfiguration.environmentConfiguration().stream().flatMap(e -> e.targets.stream().map(t -> Pair.of((Object)e.name, (Object)t))).collect(Collectors.toMap(p -> TargetId.of(((TargetDto)p.getRight()).name, (String)p.getLeft()), Function.identity()));
        for (ExploreResult.Link<AgentId, TargetId> link : exploreResult.targetLinks()) {
            Agent sourceAgent = agentsByName.get(link.source().name());
            Pair destTarget = (Pair)targetById.get(link.destination());
            if (sourceAgent == null) {
                throw new IllegalStateException(String.format("the agent [%s] is declared as source but does not exist in configuration", link.source()));
            }
            if (destTarget == null) {
                throw new IllegalStateException(String.format("the target [%s] is declared as destination but does not exist in configuration", link.destination()));
            }
            sourceAgent.addReachable(TargetId.of(((TargetDto)destTarget.getRight()).name, (String)destTarget.getLeft()));
        }
        return new AgentGraph(new HashSet<Agent>(agentsByName.values()));
    }

    private static Agent searchInConfiguration(Map<String, Agent> agentsByName, Map<String, Agent> agentsByHost, AgentId agentId) {
        return agentsByName.getOrDefault(agentId.name(), agentsByHost.get(agentId.name()));
    }

    private static Map<String, Agent> indexAgents(NetworkConfiguration networkConfiguration, Function<Agent, String> indexFunction) {
        return networkConfiguration.agentNetworkConfiguration().stream().map(Agent::new).collect(Collectors.toMap(indexFunction, Function.identity()));
    }

    public AgentGraph(Collection<Agent> agents) {
        this.agents = new LinkedHashSet<Agent>(agents);
    }

    public Set<Agent> agents() {
        return new LinkedHashSet<Agent>(this.agents);
    }

    Optional<Agent> getBy(AgentId agentId) {
        return this.agents.stream().filter(agent -> agent.agentInfo.name().equals(agentId.name())).findFirst();
    }
}

