/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.api;

import fr.enedis.chutney.campaign.api.dto.SchedulingCampaignDto;
import fr.enedis.chutney.campaign.domain.ScheduledCampaignRepository;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ui/campaign/v1/scheduling"})
public class ScheduleCampaignController {
    private final ScheduledCampaignRepository scheduledCampaignRepository;

    public ScheduleCampaignController(ScheduledCampaignRepository scheduledCampaignRepository) {
        this.scheduledCampaignRepository = scheduledCampaignRepository;
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_READ')")
    @GetMapping(path={""}, produces={"application/json"})
    public List<SchedulingCampaignDto> getAll() {
        return this.scheduledCampaignRepository.getAll().stream().map(SchedulingCampaignDto::toDto).sorted(Comparator.comparing(SchedulingCampaignDto::getSchedulingDate)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @PostMapping(path={""}, consumes={"application/json"}, produces={"application/json"})
    public void add(@RequestBody SchedulingCampaignDto dto) {
        this.scheduledCampaignRepository.add(SchedulingCampaignDto.fromDto(dto));
    }

    @PreAuthorize(value="hasAuthority('CAMPAIGN_WRITE')")
    @DeleteMapping(path={"/{schedulingCampaignId}"}, produces={"application/json"})
    public void delete(@PathVariable(value="schedulingCampaignId") Long schedulingCampaignId) {
        this.scheduledCampaignRepository.removeById(schedulingCampaignId);
    }
}

