/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistory;
import fr.enedis.chutney.server.core.domain.execution.report.ServerReportStatus;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ScenarioExecutionReportOutlineDto {
    private String scenarioId;
    private String scenarioName;
    private ExecutionHistory.ExecutionSummary execution;

    public ScenarioExecutionReportOutlineDto(String scenarioId, String scenarioName, ExecutionHistory.ExecutionSummary execution) {
        this.scenarioId = scenarioId;
        this.scenarioName = scenarioName;
        this.execution = execution;
    }

    public String getScenarioId() {
        return this.scenarioId;
    }

    public Long getExecutionId() {
        return this.execution.executionId();
    }

    public long getDuration() {
        return this.execution.duration();
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public LocalDateTime getStartDate() {
        return this.execution.time();
    }

    public ServerReportStatus getStatus() {
        return this.execution.status();
    }

    public String getInfo() {
        return this.execution.info().orElse("");
    }

    public String getError() {
        return this.execution.error().orElse("");
    }

    public Set<String> getTags() {
        return this.execution.tags().orElse(Collections.emptySet());
    }

    public DataSet getDataset() {
        return this.execution.dataset().orElse(null);
    }

    ExecutionHistory.ExecutionSummary getExecution() {
        return this.execution;
    }
}

