/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.api.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import fr.enedis.chutney.campaign.domain.Frequency;
import fr.enedis.chutney.campaign.domain.PeriodicScheduledCampaign;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SchedulingCampaignDto {
    private Long id;
    private LocalDateTime schedulingDate;
    private String frequency;
    private String environment;
    private List<CampaignExecutionRequestDto> campaignExecutionRequest = new ArrayList<CampaignExecutionRequestDto>();

    @JsonCreator
    public SchedulingCampaignDto() {
    }

    public SchedulingCampaignDto(Long id, LocalDateTime schedulingDate, String frequency, String environment, List<CampaignExecutionRequestDto> campaignExecutionRequest) {
        this.id = id;
        this.schedulingDate = schedulingDate;
        this.frequency = frequency;
        this.environment = environment;
        this.campaignExecutionRequest = campaignExecutionRequest;
    }

    public Long getId() {
        return this.id;
    }

    public LocalDateTime getSchedulingDate() {
        return this.schedulingDate;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public List<CampaignExecutionRequestDto> getCampaignExecutionRequest() {
        return this.campaignExecutionRequest;
    }

    public static SchedulingCampaignDto toDto(PeriodicScheduledCampaign sc) {
        return new SchedulingCampaignDto(sc.id, sc.nextExecutionDate, sc.frequency.label, sc.environment, sc.campaignExecutionRequests.stream().map(cer -> new CampaignExecutionRequestDto(cer.campaignId(), cer.campaignTitle(), cer.datasetId())).toList());
    }

    public static PeriodicScheduledCampaign fromDto(SchedulingCampaignDto dto) {
        return new PeriodicScheduledCampaign(dto.id, dto.getSchedulingDate(), Frequency.toFrequency(dto.getFrequency()), dto.getEnvironment(), dto.campaignExecutionRequest.stream().map(cer -> new PeriodicScheduledCampaign.CampaignExecutionRequest(cer.campaignId(), cer.campaignTitle(), cer.datasetId())).toList());
    }

    public record CampaignExecutionRequestDto(Long campaignId, String campaignTitle, String datasetId) {
    }
}

