/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.infra;

import fr.enedis.chutney.campaign.domain.CampaignExecutionRepository;
import fr.enedis.chutney.campaign.domain.CampaignNotFoundException;
import fr.enedis.chutney.campaign.infra.CampaignExecutionJpaRepository;
import fr.enedis.chutney.campaign.infra.CampaignJpaRepository;
import fr.enedis.chutney.campaign.infra.jpa.CampaignEntity;
import fr.enedis.chutney.campaign.infra.jpa.CampaignExecutionEntity;
import fr.enedis.chutney.execution.domain.campaign.CampaignExecutionNotFoundException;
import fr.enedis.chutney.execution.infra.storage.DatabaseExecutionJpaRepository;
import fr.enedis.chutney.execution.infra.storage.jpa.ScenarioExecutionEntity;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import fr.enedis.chutney.server.core.domain.scenario.campaign.CampaignExecution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class CampaignExecutionDBRepository
implements CampaignExecutionRepository {
    private final CampaignExecutionJpaRepository campaignExecutionJpaRepository;
    private final CampaignJpaRepository campaignJpaRepository;
    private final DatabaseExecutionJpaRepository scenarioExecutionJpaRepository;
    private final Map<Long, List<CampaignExecution>> currentCampaignExecutions = new ConcurrentHashMap<Long, List<CampaignExecution>>();

    public CampaignExecutionDBRepository(CampaignExecutionJpaRepository campaignExecutionJpaRepository, CampaignJpaRepository campaignJpaRepository, DatabaseExecutionJpaRepository scenarioExecutionJpaRepository) {
        this.campaignExecutionJpaRepository = campaignExecutionJpaRepository;
        this.campaignJpaRepository = campaignJpaRepository;
        this.scenarioExecutionJpaRepository = scenarioExecutionJpaRepository;
    }

    @Override
    public List<CampaignExecution> currentExecutions(Long campaignId) {
        return this.currentCampaignExecutions.getOrDefault(campaignId, Collections.emptyList());
    }

    @Override
    public void startExecution(Long campaignId, CampaignExecution campaignExecution) {
        List<CampaignExecution> campaignExecutions = new ArrayList<CampaignExecution>();
        if (this.currentCampaignExecutions.containsKey(campaignId)) {
            campaignExecutions = this.currentCampaignExecutions.get(campaignId);
        }
        campaignExecutions.add(campaignExecution);
        this.currentCampaignExecutions.put(campaignId, campaignExecutions);
    }

    @Override
    public void stopExecution(Long campaignId, String environment) {
        this.currentCampaignExecutions.get(campaignId).removeIf(exec -> exec.executionEnvironment.equals(environment));
        if (this.currentCampaignExecutions.get(campaignId).isEmpty()) {
            this.currentCampaignExecutions.remove(campaignId);
        }
    }

    @Override
    public CampaignExecution getLastExecution(Long campaignId) {
        return this.campaignExecutionJpaRepository.findFirstByCampaignIdOrderByIdDesc(campaignId).map(this::toDomain).orElseThrow(() -> new CampaignExecutionNotFoundException(campaignId));
    }

    @Override
    @Transactional
    public void deleteExecutions(Set<Long> executionsIds) {
        List executions = this.campaignExecutionJpaRepository.findAllById(executionsIds);
        List scenarioExecutions = executions.stream().flatMap(cer -> cer.scenarioExecutions().stream()).toList();
        scenarioExecutions.forEach(ScenarioExecutionEntity::clearCampaignExecution);
        this.scenarioExecutionJpaRepository.saveAll(scenarioExecutions);
        this.campaignExecutionJpaRepository.deleteAllInBatch(executions);
    }

    @Override
    public List<CampaignExecution> getExecutionHistory(Long campaignId) {
        return this.campaignExecutionJpaRepository.findByCampaignIdOrderByIdDesc(campaignId).stream().map(this::toDomain).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    @Transactional
    public void saveCampaignExecution(Long campaignId, CampaignExecution campaignExecution) {
        CampaignExecutionEntity execution = (CampaignExecutionEntity)this.campaignExecutionJpaRepository.findById(campaignExecution.executionId).orElseThrow(() -> new CampaignExecutionNotFoundException(campaignId, campaignExecution.executionId));
        List scenarioExecutions = this.scenarioExecutionJpaRepository.findAllById(campaignExecution.scenarioExecutionReports().stream().map(serc -> serc.execution().executionId()).toList());
        execution.updateFromDomain(campaignExecution, scenarioExecutions);
        this.campaignExecutionJpaRepository.save(execution);
    }

    @Override
    public List<CampaignExecution> getLastExecutions(Long numberOfExecution) {
        return this.campaignExecutionJpaRepository.findAll((Pageable)PageRequest.of((int)0, (int)numberOfExecution.intValue(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}))).stream().map(this::toDomain).toList();
    }

    @Override
    public CampaignExecution getCampaignExecutionById(Long campaignExecId) {
        return this.campaignExecutionJpaRepository.findById(campaignExecId).map(this::toDomain).orElseThrow(() -> new CampaignExecutionNotFoundException(null, campaignExecId));
    }

    @Override
    @Transactional
    public void clearAllExecutionHistory(Long campaignId) {
        List<CampaignExecutionEntity> campaignExecutionEntities = this.campaignExecutionJpaRepository.findAllByCampaignId(campaignId);
        List scenarioExecutions = campaignExecutionEntities.stream().flatMap(ce -> ce.scenarioExecutions().stream()).toList();
        scenarioExecutions.forEach(ScenarioExecutionEntity::clearCampaignExecution);
        this.scenarioExecutionJpaRepository.saveAll(scenarioExecutions);
        this.campaignExecutionJpaRepository.deleteAllInBatch(campaignExecutionEntities);
    }

    @Override
    @Transactional
    public Long generateCampaignExecutionId(Long campaignId, String environment, DataSet dataset) {
        Validate.notNull((Object)campaignId, (String)"Campaign ID cannot be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)environment, (String)"Environment cannot be null or empty", (Object[])new Object[0]);
        CampaignExecutionEntity newExecution = new CampaignExecutionEntity(campaignId, environment, dataset);
        this.campaignExecutionJpaRepository.save(newExecution);
        return newExecution.id();
    }

    private CampaignExecution toDomain(CampaignExecutionEntity campaignExecution) {
        CampaignEntity campaign = (CampaignEntity)this.campaignJpaRepository.findById(campaignExecution.campaignId()).orElseThrow(() -> new CampaignNotFoundException(campaignExecution.campaignId()));
        return Optional.ofNullable(this.runningCampaignExecution(campaignExecution)).orElseGet(() -> campaignExecution.toDomain(campaign.title()));
    }

    private CampaignExecution runningCampaignExecution(CampaignExecutionEntity campaignExecutionEntity) {
        return this.currentExecutions(campaignExecutionEntity.campaignId()).stream().filter(exec -> exec.executionId.equals(campaignExecutionEntity.id())).findAny().orElse(null);
    }
}

