/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.infra;

import com.google.common.base.Strings;
import fr.enedis.chutney.campaign.domain.CampaignExecutionRepository;
import fr.enedis.chutney.campaign.domain.CampaignNotFoundException;
import fr.enedis.chutney.campaign.domain.CampaignRepository;
import fr.enedis.chutney.campaign.domain.ScheduledCampaignRepository;
import fr.enedis.chutney.campaign.infra.CampaignExecutionDBRepository;
import fr.enedis.chutney.campaign.infra.CampaignJpaRepository;
import fr.enedis.chutney.campaign.infra.CampaignScenarioJpaRepository;
import fr.enedis.chutney.campaign.infra.jpa.CampaignEntity;
import fr.enedis.chutney.campaign.infra.jpa.CampaignScenarioEntity;
import fr.enedis.chutney.server.core.domain.scenario.campaign.Campaign;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(readOnly=true)
public class DatabaseCampaignRepository
implements CampaignRepository {
    private final CampaignJpaRepository campaignJpaRepository;
    private final CampaignScenarioJpaRepository campaignScenarioJpaRepository;
    private final CampaignExecutionRepository campaignExecutionRepository;
    private final ScheduledCampaignRepository scheduledCampaignRepository;

    public DatabaseCampaignRepository(CampaignJpaRepository campaignJpaRepository, CampaignScenarioJpaRepository campaignScenarioJpaRepository, CampaignExecutionDBRepository campaignExecutionRepository, ScheduledCampaignRepository scheduledCampaignRepository) {
        this.campaignJpaRepository = campaignJpaRepository;
        this.campaignScenarioJpaRepository = campaignScenarioJpaRepository;
        this.campaignExecutionRepository = campaignExecutionRepository;
        this.scheduledCampaignRepository = scheduledCampaignRepository;
    }

    @Override
    @Transactional
    public Campaign createOrUpdate(Campaign campaign) {
        if (campaign.id != null && !this.campaignJpaRepository.existsById(campaign.id)) {
            CampaignEntity campaignEntity = CampaignEntity.fromDomain(campaign, 1);
            this.campaignJpaRepository.saveWithExplicitId(campaignEntity.id(), campaignEntity.title(), campaignEntity.description());
        }
        CampaignEntity campaignJpa = (CampaignEntity)this.campaignJpaRepository.save(CampaignEntity.fromDomain(campaign, this.lastCampaignVersion(campaign.id)));
        return campaignJpa.toDomain();
    }

    private Integer lastCampaignVersion(Long id) {
        return Optional.ofNullable(id).flatMap(arg_0 -> ((CampaignJpaRepository)this.campaignJpaRepository).findById(arg_0)).map(CampaignEntity::version).orElse(null);
    }

    @Override
    @Transactional
    public boolean removeById(Long id) {
        if (this.campaignJpaRepository.existsById(id)) {
            this.campaignExecutionRepository.clearAllExecutionHistory(id);
            this.campaignJpaRepository.deleteById(id);
            this.scheduledCampaignRepository.removeCampaignId(id);
            return true;
        }
        return false;
    }

    @Override
    public Campaign findById(Long campaignId) throws CampaignNotFoundException {
        return this.campaignJpaRepository.findById(campaignId).map(CampaignEntity::toDomain).orElseThrow(() -> new CampaignNotFoundException(campaignId));
    }

    @Override
    public List<Campaign> findByName(String campaignName) {
        return this.campaignJpaRepository.findAll((Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("title")), campaignName.toLowerCase())).stream().map(CampaignEntity::toDomain).toList();
    }

    @Override
    public List<String> findScenariosIds(Long campaignId) {
        return this.campaignJpaRepository.findById(campaignId).map(c -> c.campaignScenarios().stream().map(CampaignScenarioEntity::scenarioId).toList()).orElseThrow(() -> new CampaignNotFoundException(campaignId));
    }

    @Override
    public List<Campaign> findAll() {
        return StreamSupport.stream(this.campaignJpaRepository.findAll().spliterator(), false).map(CampaignEntity::toDomain).toList();
    }

    @Override
    public List<Campaign> findCampaignsByScenarioId(String scenarioId) {
        if (Strings.isNullOrEmpty((String)scenarioId)) {
            return Collections.emptyList();
        }
        return this.campaignScenarioJpaRepository.findAllByScenarioId(scenarioId).stream().map(CampaignScenarioEntity::campaign).distinct().map(CampaignEntity::toDomain).toList();
    }

    @Override
    public List<Campaign> findCampaignsByEnvironment(String environment) {
        if (Strings.isNullOrEmpty((String)environment)) {
            return Collections.emptyList();
        }
        return this.campaignJpaRepository.findByEnvironment(environment).stream().map(CampaignEntity::toDomain).toList();
    }

    @Override
    public List<Campaign> findCampaignsByDatasetId(String datasetId) {
        if (Strings.isNullOrEmpty((String)datasetId)) {
            return Collections.emptyList();
        }
        return this.campaignJpaRepository.findByDatasetId(datasetId).stream().map(CampaignEntity::toDomain).toList();
    }
}

