/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.infra;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import fr.enedis.chutney.campaign.infra.SchedulingCampaignDto;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

class SchedulingCampaignsDtoDeserializer
extends StdDeserializer<SchedulingCampaignDto> {
    protected SchedulingCampaignsDtoDeserializer() {
        super(SchedulingCampaignDto.class);
    }

    public SchedulingCampaignDto deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode node = (JsonNode)parser.readValueAsTree();
        String id = node.get("id").asText();
        LocalDateTime schedulingDate = this.getSchedulingDate(node);
        String frequency = this.getFrequency(node);
        List<Long> campaignsId = this.getLongList(node.get("campaignsId"));
        List<String> campaignsTitle = this.getStringList(node.get("campaignsTitle"));
        String environment = node.has("environment") ? node.get("environment").asText() : null;
        List<String> datasetIds = this.getStringList(node.get("datasetsId"));
        List<SchedulingCampaignDto.CampaignExecutionRequestDto> campaignExecutionRequestDto = IntStream.range(0, campaignsId.size()).mapToObj(i -> new SchedulingCampaignDto.CampaignExecutionRequestDto((Long)campaignsId.get(i), (String)campaignsTitle.get(i), this.guardArrayOfBoundException(datasetIds, i))).collect(Collectors.toList());
        return new SchedulingCampaignDto(id, schedulingDate, frequency, environment, campaignExecutionRequestDto);
    }

    private String guardArrayOfBoundException(List<String> list, int i) {
        if (i < list.size()) {
            return list.get(i);
        }
        return "";
    }

    private List<Long> getLongList(JsonNode node) {
        return this.extractList(node, JsonNode::asLong);
    }

    private List<String> getStringList(JsonNode node) {
        return this.extractList(node, JsonNode::asText);
    }

    private <T> List<T> extractList(JsonNode node, Function<JsonNode, T> mapper) {
        if (node == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(node.spliterator(), false).map(mapper).collect(Collectors.toCollection(ArrayList::new));
    }

    private LocalDateTime getSchedulingDate(JsonNode node) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
        return (LocalDateTime)objectMapper.readValue(node.get("schedulingDate").toString(), LocalDateTime.class);
    }

    private String getFrequency(JsonNode node) {
        return node.has("frequency") ? node.get("frequency").asText() : null;
    }
}

