/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.campaign.infra.jpa;

import fr.enedis.chutney.execution.infra.execution.DatasetEntityMapper;
import fr.enedis.chutney.execution.infra.storage.jpa.ScenarioExecutionEntity;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import fr.enedis.chutney.server.core.domain.execution.report.ServerReportStatus;
import fr.enedis.chutney.server.core.domain.scenario.campaign.CampaignExecution;
import fr.enedis.chutney.server.core.domain.scenario.campaign.CampaignExecutionReportBuilder;
import fr.enedis.chutney.server.core.domain.scenario.campaign.ScenarioExecutionCampaign;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Version;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Entity(name="CAMPAIGN_EXECUTIONS")
public class CampaignExecutionEntity {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="CAMPAIGN_ID")
    private Long campaignId;
    @OneToMany(mappedBy="campaignExecution")
    private List<ScenarioExecutionEntity> scenarioExecutions;
    @Column(name="PARTIAL")
    private Boolean partial;
    @Column(name="ENVIRONMENT")
    private String environment;
    @Column(name="USER_ID")
    private String userId;
    @Column(name="DATASET_ID")
    private String datasetId;
    @Column(name="DATASET_CONSTANTS")
    private String datasetConstants;
    @Column(name="DATASET_DATATABLE")
    private String datasetDatatable;
    @Column(name="VERSION")
    @Version
    private Integer version;

    public CampaignExecutionEntity() {
    }

    public CampaignExecutionEntity(Long campaignId, String environment, DataSet dataset) {
        this(null, campaignId, null, null, environment, null, dataset, null);
    }

    private CampaignExecutionEntity(Long id, Long campaignId, List<ScenarioExecutionEntity> scenarioExecutions, Boolean partial, String environment, String userId, DataSet dataset, Integer version) {
        this.id = id;
        this.campaignId = campaignId;
        this.scenarioExecutions = scenarioExecutions;
        this.partial = Optional.ofNullable(partial).orElse(false);
        this.environment = environment;
        this.userId = userId;
        this.computeDataset(dataset);
        this.version = version;
    }

    public Long id() {
        return this.id;
    }

    public Long campaignId() {
        return this.campaignId;
    }

    public List<ScenarioExecutionEntity> scenarioExecutions() {
        return this.scenarioExecutions;
    }

    public String environment() {
        return this.environment;
    }

    public void updateFromDomain(CampaignExecution report, Iterable<ScenarioExecutionEntity> scenarioExecutions) {
        this.partial = report.partialExecution;
        this.environment = report.executionEnvironment;
        this.userId = report.userId;
        this.computeDataset(report.dataset);
        Optional.ofNullable(this.scenarioExecutions).ifPresent(see -> {
            see.clear();
            scenarioExecutions.forEach(se -> {
                se.forCampaignExecution(this);
                see.add(se);
            });
        });
    }

    public CampaignExecution toDomain(String campaignTitle) {
        List scenarioExecutionReports = Optional.ofNullable(this.scenarioExecutions).map(see -> see.stream().map(se -> new ScenarioExecutionCampaign(se.scenarioId(), se.scenarioTitle(), se.toDomain())).collect(Collectors.toCollection(ArrayList::new))).orElseGet(ArrayList::new);
        CampaignExecutionReportBuilder campaignExecutionReportBuilder = CampaignExecutionReportBuilder.builder().executionId(this.id).campaignId(this.campaignId).campaignName(campaignTitle).partialExecution(Optional.ofNullable(this.partial).orElse(false).booleanValue()).environment(this.environment).dataset(DatasetEntityMapper.getDataset(this.datasetId, this.datasetConstants, this.datasetDatatable)).userId(this.userId);
        if (scenarioExecutionReports.isEmpty()) {
            campaignExecutionReportBuilder.status(ServerReportStatus.SUCCESS).startDate(LocalDateTime.MIN);
        } else {
            campaignExecutionReportBuilder.scenarioExecutionReport(scenarioExecutionReports);
        }
        return campaignExecutionReportBuilder.build();
    }

    private void computeDataset(DataSet dataset) {
        Optional.ofNullable(dataset).ifPresent(ds -> {
            this.datasetId = CampaignExecutionEntity.mapDataset(ds);
            this.datasetConstants = DatasetEntityMapper.datasetConstantsToString(ds.constants);
            this.datasetDatatable = DatasetEntityMapper.datasetDatatableToString(ds.datatable);
        });
    }

    private static String mapDataset(DataSet dataset) {
        if (dataset.id != null) {
            return dataset.id;
        }
        if (dataset.name != null && dataset.name.isEmpty()) {
            return DataSet.CUSTOM_ID;
        }
        return null;
    }
}

