/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.dataset.api;

import fr.enedis.chutney.dataset.api.DataSetDto;
import fr.enedis.chutney.dataset.api.ExecutionDatasetDto;
import fr.enedis.chutney.dataset.api.ImmutableDataSetDto;
import fr.enedis.chutney.dataset.api.KeyValue;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class DataSetMapper {
    public static DataSetDto toDto(DataSet dataSet) {
        if (dataSet == null) {
            return null;
        }
        ImmutableDataSetDto.Builder datasetBuilder = ImmutableDataSetDto.builder().name("");
        if (dataSet.id != null) {
            datasetBuilder.id(dataSet.id);
        }
        if (dataSet.name != null) {
            datasetBuilder.name(dataSet.name);
        }
        if (dataSet.constants != null) {
            datasetBuilder.constants(KeyValue.fromMap(dataSet.constants));
        }
        if (dataSet.datatable != null) {
            datasetBuilder.datatable(dataSet.datatable.stream().map(KeyValue::fromMap).toList());
        }
        if (dataSet.tags != null) {
            datasetBuilder.tags(dataSet.tags);
        }
        if (dataSet.description != null) {
            datasetBuilder.description(dataSet.description);
        }
        if (dataSet.creationDate != null) {
            datasetBuilder.lastUpdated(dataSet.creationDate);
        }
        if (dataSet.campaignUsage != null) {
            datasetBuilder.campaignUsage(dataSet.campaignUsage);
        }
        if (dataSet.scenarioUsage != null) {
            datasetBuilder.scenarioUsage(dataSet.scenarioUsage);
        }
        if (dataSet.scenarioInCampaignUsage != null) {
            datasetBuilder.scenarioInCampaignUsage(dataSet.scenarioInCampaignUsage);
        }
        return datasetBuilder.build();
    }

    public static DataSet fromDto(DataSetDto dto) {
        return DataSet.builder().withId((String)dto.id().orElse(null)).withName(dto.name()).withDescription(dto.description()).withCreationDate(dto.lastUpdated()).withTags(dto.tags()).withConstants(KeyValue.toMap(dto.constants())).withDatatable(Optional.ofNullable(dto.datatable()).map(datatable -> datatable.stream().map(KeyValue::toMap).toList()).orElse(Collections.emptyList())).build();
    }

    public static DataSet fromExecutionDatasetDto(ExecutionDatasetDto dto, Function<String, DataSet> findById) {
        if (dto == null) {
            return null;
        }
        if (dto.getId() != null && !dto.getId().equals(DataSet.CUSTOM_ID)) {
            return findById.apply(dto.getId());
        }
        if (dto.isEmpty()) {
            return null;
        }
        return DataSet.builder().withId(dto.getId()).withName("").withConstants((Map)Optional.ofNullable(dto.getConstants()).map(KeyValue::toMap).orElse(null)).withDatatable((List)Optional.ofNullable(dto.getDatatable()).map(datatable -> datatable.stream().map(KeyValue::toMap).toList()).orElse(null)).build();
    }
}

