/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.dataset.domain;

import fr.enedis.chutney.campaign.domain.CampaignRepository;
import fr.enedis.chutney.dataset.domain.DataSetRepository;
import fr.enedis.chutney.scenario.domain.gwt.GwtTestCase;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import fr.enedis.chutney.server.core.domain.dataset.DataSetNotFoundException;
import fr.enedis.chutney.server.core.domain.scenario.AggregatedRepository;
import fr.enedis.chutney.server.core.domain.scenario.TestCase;
import fr.enedis.chutney.server.core.domain.scenario.TestCaseMetadata;
import fr.enedis.chutney.server.core.domain.scenario.TestCaseMetadataImpl;
import fr.enedis.chutney.server.core.domain.scenario.campaign.Campaign;
import fr.enedis.chutney.server.core.domain.scenario.campaign.CampaignBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DatasetService {
    private final DataSetRepository datasetRepository;
    private final CampaignRepository campaignRepository;
    private final AggregatedRepository<GwtTestCase> testCaseRepository;

    public DatasetService(DataSetRepository dataSetRepository, CampaignRepository campaignRepository, AggregatedRepository<GwtTestCase> testCaseRepository) {
        this.datasetRepository = dataSetRepository;
        this.campaignRepository = campaignRepository;
        this.testCaseRepository = testCaseRepository;
    }

    public DataSet findById(String id) {
        return this.datasetRepository.findById(id);
    }

    public List<DataSet> findAll(Boolean usage) {
        Stream datasets = this.datasetRepository.findAll().stream().sorted(DataSet.datasetComparator);
        if (!usage.booleanValue()) {
            return datasets.toList();
        }
        return datasets.map(dataset -> {
            List<Campaign> campaigns = this.campaignRepository.findAll();
            Set campaignsUsingDataset = campaigns.stream().filter(campaign -> dataset.id.equals(campaign.executionDataset())).map(campaign -> campaign.title).collect(Collectors.toSet());
            Map scenarioInCampaignUsingDataset = campaigns.stream().filter(campaign -> campaign.scenarios.stream().anyMatch(scenario -> dataset.id.equals(scenario.datasetId()))).collect(Collectors.groupingBy(campaign -> campaign.title, Collectors.flatMapping(campaign -> campaign.scenarios.stream().filter(campaignScenario -> dataset.id.equals(campaignScenario.datasetId())).map(campaignScenario -> this.testCaseRepository.findById(campaignScenario.scenarioId())).map(scenario -> scenario.map(s -> s.metadata.title).orElseThrow()), Collectors.toSet())));
            Set scenariosUsingDataset = this.testCaseRepository.findAllByDatasetId(dataset.id).stream().map(TestCaseMetadata::title).collect(Collectors.toSet());
            return DataSet.builder().fromDataSet(dataset).withCampaignUsage(campaignsUsingDataset).withScenarioUsage(scenariosUsingDataset).withScenarioInCampaign(scenarioInCampaignUsingDataset).build();
        }).toList();
    }

    public DataSet save(DataSet dataset) {
        String id = this.datasetRepository.save(dataset);
        return DataSet.builder().fromDataSet(dataset).withId(id).build();
    }

    public DataSet updateWithRename(String oldId, DataSet dataset) {
        if (StringUtils.isBlank((CharSequence)oldId)) {
            throw new DataSetNotFoundException("");
        }
        DataSet newDataset = this.save(dataset);
        String newId = newDataset.id;
        if (!oldId.equals(newId)) {
            this.updateScenarios(oldId, newId);
            this.updateCampaigns(oldId, newId);
            this.datasetRepository.removeById(oldId);
        }
        return newDataset;
    }

    private void updateScenarios(String oldId, String newId) {
        this.testCaseRepository.findAll().stream().filter(m -> oldId.equals(m.defaultDataset())).map(m -> this.testCaseRepository.findById(m.id())).forEach(o -> o.ifPresent(tc -> this.testCaseRepository.save((TestCase)GwtTestCase.builder().from((GwtTestCase)tc).withMetadata(TestCaseMetadataImpl.TestCaseMetadataBuilder.from((TestCaseMetadata)tc.metadata).withDefaultDataset(newId).build()).build())));
    }

    private void updateCampaigns(String oldId, String newId) {
        this.campaignRepository.findAll().stream().filter(c -> oldId.equals(c.executionDataset())).forEach(c -> this.campaignRepository.createOrUpdate(CampaignBuilder.builder().from(c).setDatasetId(newId).build()));
    }

    public void remove(String datasetName) {
        this.datasetRepository.removeById(datasetName);
        this.updateScenarios(datasetName, "");
        this.updateCampaigns(datasetName, "");
    }
}

