/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.dataset.infra;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import fr.enedis.chutney.dataset.domain.DataSetRepository;
import fr.enedis.chutney.dataset.infra.DatasetDto;
import fr.enedis.chutney.dataset.infra.DatasetMapper;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import fr.enedis.chutney.server.core.domain.dataset.DataSetAlreadyExistException;
import fr.enedis.chutney.server.core.domain.dataset.DataSetNotFoundException;
import fr.enedis.chutney.tools.file.FileUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FileDatasetRepository
implements DataSetRepository {
    private static final String FILE_EXTENSION = ".json";
    static final Path ROOT_DIRECTORY_NAME = Paths.get("dataset", new String[0]);
    private final Path storeFolderPath;
    private final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT);

    FileDatasetRepository(@Value(value="${chutney.configuration-folder:~/.chutney/conf}") String storeFolderPath) throws UncheckedIOException {
        this.storeFolderPath = Paths.get(storeFolderPath, new String[0]).resolve(ROOT_DIRECTORY_NAME);
        FileUtils.initFolder((Path)this.storeFolderPath);
    }

    @Override
    public String save(DataSet dataSet) {
        if (this.alreadyExists(dataSet)) {
            throw new DataSetAlreadyExistException(dataSet.name);
        }
        DatasetDto dto = DatasetMapper.toDto(dataSet);
        Path file = this.storeFolderPath.resolve(dto.id + FILE_EXTENSION);
        FileUtils.createFile((Path)file);
        try {
            String jsonContent = this.objectMapper.writeValueAsString((Object)dto);
            FileUtils.writeContent((Path)file, (String)jsonContent);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot save " + String.valueOf(file.toUri()), e);
        }
        return dto.id;
    }

    private boolean alreadyExists(DataSet dataSet) {
        if (dataSet.id != null) {
            return false;
        }
        try {
            DataSet byId = this.findById(dataSet.name);
            return !byId.equals((Object)DataSet.NO_DATASET);
        }
        catch (DataSetNotFoundException e) {
            return false;
        }
    }

    @Override
    public DataSet findById(String fileName) {
        if (null == fileName || fileName.isBlank()) {
            return DataSet.NO_DATASET;
        }
        Path file = this.storeFolderPath.resolve(fileName + FILE_EXTENSION);
        try {
            String content = FileUtils.readContent((Path)file);
            BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            return DatasetMapper.fromDto((DatasetDto)this.objectMapper.readValue(content, DatasetDto.class), attr.creationTime().toInstant());
        }
        catch (IOException | UncheckedIOException e) {
            throw new DataSetNotFoundException("Cannot read " + String.valueOf(file.toUri()), (Throwable)e);
        }
    }

    @Override
    public void removeById(String fileName) {
        Path filePath = this.storeFolderPath.resolve(fileName + FILE_EXTENSION);
        FileUtils.delete((Path)filePath);
    }

    @Override
    public List<DataSet> findAll() {
        return (List)FileUtils.doOnListFiles((Path)this.storeFolderPath, pathStream -> pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(FileUtils::getNameWithoutExtension).sorted(Comparator.naturalOrder()).map(this::findById).collect(Collectors.toList()));
    }
}

