/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import fr.enedis.chutney.execution.api.ImmutableExecutionSummaryDto;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistory;
import fr.enedis.chutney.server.core.domain.execution.history.ImmutableExecutionHistory;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableExecutionSummaryDto.class)
@JsonDeserialize(as=ImmutableExecutionSummaryDto.class)
@Value.Immutable
public interface ExecutionSummaryDto
extends ExecutionHistory.ExecutionProperties,
ExecutionHistory.Attached,
ExecutionHistory.WithScenario {
    public static List<ExecutionSummaryDto> toDto(Collection<ExecutionHistory.ExecutionSummary> executionSummaryList) {
        return executionSummaryList.stream().map(ExecutionSummaryDto::toDto).collect(Collectors.toList());
    }

    public static ExecutionSummaryDto toDto(ExecutionHistory.ExecutionSummary executionSummary) {
        return ImmutableExecutionSummaryDto.builder().time(executionSummary.time()).duration(executionSummary.duration()).status(executionSummary.status()).info(executionSummary.info()).error(executionSummary.error()).executionId(executionSummary.executionId()).testCaseTitle(executionSummary.testCaseTitle()).environment(executionSummary.environment()).dataset(executionSummary.dataset()).user(executionSummary.user()).campaignReport(executionSummary.campaignReport()).scenarioId(executionSummary.scenarioId()).tags(executionSummary.tags()).build();
    }

    public static List<ExecutionHistory.ExecutionSummary> fromDto(Collection<ExecutionSummaryDto> executionSummaryList) {
        return executionSummaryList.stream().map(ExecutionSummaryDto::fromDto).collect(Collectors.toList());
    }

    public static ExecutionHistory.ExecutionSummary fromDto(ExecutionSummaryDto dto) {
        return ImmutableExecutionHistory.ExecutionSummary.builder().time(dto.time()).duration(dto.duration()).status(dto.status()).info(dto.info()).error(dto.error()).executionId(dto.executionId()).testCaseTitle(dto.testCaseTitle()).environment(dto.environment()).user(dto.user()).scenarioId(dto.scenarioId()).tags(dto.tags()).build();
    }
}

