/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.api.report.search;

import fr.enedis.chutney.execution.api.ExecutionSummaryDto;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistoryRepository;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/execution"})
public class ExecutionSearchController {
    private final ExecutionHistoryRepository executionHistoryRepository;

    ExecutionSearchController(ExecutionHistoryRepository executionHistoryRepository) {
        this.executionHistoryRepository = executionHistoryRepository;
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/search"}, produces={"application/json"})
    public List<ExecutionSummaryDto> getExecutionReportMatchQuery(@QueryParam(value="query") String query) {
        return this.executionHistoryRepository.getExecutionReportMatchKeyword(query).stream().map(ExecutionSummaryDto::toDto).toList();
    }
}

