/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.api.report.surefire;

import fr.enedis.chutney.execution.api.report.surefire.CampaignReportFolder;
import fr.enedis.chutney.execution.api.report.surefire.SurefireScenarioExecutionReportBuilder;
import fr.enedis.chutney.execution.api.report.surefire.Testsuite;
import fr.enedis.chutney.server.core.domain.scenario.campaign.CampaignExecution;
import fr.enedis.chutney.server.core.domain.scenario.campaign.ScenarioExecutionCampaign;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SurefireCampaignExecutionReportBuilder {
    private final SurefireScenarioExecutionReportBuilder surefireScenarioExecutionReportBuilder;

    public SurefireCampaignExecutionReportBuilder(SurefireScenarioExecutionReportBuilder surefireScenarioExecutionReportBuilder) {
        this.surefireScenarioExecutionReportBuilder = surefireScenarioExecutionReportBuilder;
    }

    public byte[] createReport(List<CampaignExecution> campaignExecutions) {
        List<CampaignReportFolder> campaignReportFolders = campaignExecutions.stream().map(this::createReport).collect(Collectors.toList());
        return this.marshall(campaignReportFolders);
    }

    private byte[] marshall(List<CampaignReportFolder> campaignReportFolders) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(baos);){
            campaignReportFolders.forEach(campaignReportFolder -> {
                try {
                    zos.putNextEntry(new ZipEntry(campaignReportFolder.name + "/"));
                    campaignReportFolder.scenariosReport.forEach(testsuite -> {
                        try {
                            zos.putNextEntry(new ZipEntry(campaignReportFolder.name + "/" + testsuite.name + ".xml"));
                            zos.write(this.zipEntry((Testsuite)testsuite));
                            zos.closeEntry();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e.getMessage(), e);
                        }
                    });
                    zos.closeEntry();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e.getMessage(), e);
                }
            });
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("Cannot serialize test suite.", e);
        }
        return baos.toByteArray();
    }

    private byte[] zipEntry(Testsuite testsuite) {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            XMLStreamWriter writer = XMLOutputFactory.newFactory().createXMLStreamWriter(output);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Testsuite.class});
            Marshaller m = jc.createMarshaller();
            m.marshal((Object)testsuite, writer);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
            catch (JAXBException | XMLStreamException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        output.close();
        return byArray;
    }

    private CampaignReportFolder createReport(CampaignExecution campaignExecution) {
        return new CampaignReportFolder(campaignExecution.campaignName, this.testsuite(campaignExecution.scenarioExecutionReports()));
    }

    private Set<Testsuite> testsuite(List<ScenarioExecutionCampaign> scenarioExecutionHistory) {
        return scenarioExecutionHistory.stream().map(this.surefireScenarioExecutionReportBuilder::create).collect(Collectors.toSet());
    }
}

