/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.api.report.surefire;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import fr.enedis.chutney.execution.api.report.surefire.ObjectFactory;
import fr.enedis.chutney.execution.api.report.surefire.Testsuite;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistoryRepository;
import fr.enedis.chutney.server.core.domain.execution.report.ScenarioExecutionReport;
import fr.enedis.chutney.server.core.domain.execution.report.ServerReportStatus;
import fr.enedis.chutney.server.core.domain.execution.report.StepExecutionReportCore;
import fr.enedis.chutney.server.core.domain.scenario.campaign.ScenarioExecutionCampaign;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.stereotype.Component;

@Component
public class SurefireScenarioExecutionReportBuilder {
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final ObjectMapper objectMapper;
    private final ExecutionHistoryRepository executionHistoryRepository;

    SurefireScenarioExecutionReportBuilder(ObjectMapper objectMapper, ExecutionHistoryRepository executionHistoryRepository) {
        this.objectMapper = objectMapper;
        this.executionHistoryRepository = executionHistoryRepository;
    }

    Testsuite create(ScenarioExecutionCampaign scenarioExecutionReport) {
        Testsuite testsuite = this.objectFactory.createTestsuite();
        testsuite.setName(scenarioExecutionReport.scenarioId() + "_" + scenarioExecutionReport.scenarioName());
        testsuite.setTime(this.toSurefireDuration(scenarioExecutionReport.execution().duration()));
        String rawReport = this.executionHistoryRepository.getExecution(scenarioExecutionReport.scenarioId(), scenarioExecutionReport.execution().executionId()).report();
        ScenarioExecutionReport executionReport = this.parse(rawReport);
        this.populateTestsuite(testsuite, executionReport);
        return testsuite;
    }

    private ScenarioExecutionReport parse(String rawReport) {
        try {
            return (ScenarioExecutionReport)this.objectMapper.readerFor(ScenarioExecutionReport.class).readValue(rawReport);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    private void populateTestsuite(Testsuite testsuite, ScenarioExecutionReport executionReport) {
        Testsuite.Properties properties = new Testsuite.Properties();
        testsuite.getProperties().add(properties);
        AtomicInteger testCounter = new AtomicInteger();
        AtomicInteger failureCounter = new AtomicInteger();
        AtomicInteger skippedCounter = new AtomicInteger();
        this.attachTestCases(testsuite, testCounter, failureCounter, skippedCounter, "", "", executionReport.report.steps);
        testsuite.setTests(String.valueOf(testCounter.get()));
        testsuite.setFailures(String.valueOf(failureCounter.get()));
        testsuite.setSkipped(String.valueOf(skippedCounter.get()));
        testsuite.setErrors("0");
    }

    private void attachTestCases(Testsuite testsuite, AtomicInteger testCounter, AtomicInteger failureCounter, AtomicInteger skippedCounter, String stepIndexPrefix, String stepNamePrefix, List<StepExecutionReportCore> steps) {
        AtomicInteger stepIndex = new AtomicInteger();
        steps.forEach(stepExecutionReport -> {
            String currentStepIndexPrefix = stepIndexPrefix + stepIndex.incrementAndGet();
            testCounter.incrementAndGet();
            Testsuite.Testcase testcase = new Testsuite.Testcase();
            String stepName = Strings.isNullOrEmpty((String)stepExecutionReport.name) ? "<no name>" : stepExecutionReport.name;
            String testcaseName = stepNamePrefix + stepName;
            testcase.setName(currentStepIndexPrefix + " - " + testcaseName);
            testcase.setTime(this.toSurefireDuration(stepExecutionReport.duration));
            if (ServerReportStatus.FAILURE == stepExecutionReport.status) {
                failureCounter.incrementAndGet();
                stepExecutionReport.errors.forEach(error -> {
                    Testsuite.Testcase.Failure failure = this.objectFactory.createTestsuiteTestcaseFailure();
                    failure.setMessage((String)error);
                    testcase.getFailure().add(failure);
                });
            } else if (ServerReportStatus.NOT_EXECUTED == stepExecutionReport.status) {
                skippedCounter.incrementAndGet();
                Testsuite.Testcase.Skipped skipped = new Testsuite.Testcase.Skipped();
                skipped.setMessage("Not executed");
                testcase.setSkipped(this.objectFactory.createTestsuiteTestcaseSkipped(skipped));
            }
            if (!stepExecutionReport.information.isEmpty()) {
                testcase.setSystemOut(this.objectFactory.createTestsuiteTestcaseSystemOut(this.toSurefireLabel(stepExecutionReport.information)));
            }
            testsuite.getTestcase().add(testcase);
            this.attachTestCases(testsuite, testCounter, failureCounter, skippedCounter, currentStepIndexPrefix + ".", testcaseName + " / ", stepExecutionReport.steps);
        });
    }

    private String toSurefireDuration(long duration) {
        return String.valueOf((double)duration / 1000.0);
    }

    private String toSurefireLabel(Collection<String> labels) {
        return String.join((CharSequence)", ", labels);
    }
}

