/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.domain.campaign;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import fr.enedis.chutney.campaign.domain.CampaignExecutionRepository;
import fr.enedis.chutney.campaign.domain.CampaignNotFoundException;
import fr.enedis.chutney.campaign.domain.CampaignRepository;
import fr.enedis.chutney.dataset.domain.DataSetRepository;
import fr.enedis.chutney.execution.domain.campaign.CampaignAlreadyRunningException;
import fr.enedis.chutney.execution.domain.campaign.CampaignEmptyExecutionException;
import fr.enedis.chutney.execution.domain.campaign.CampaignExecutionNotFoundException;
import fr.enedis.chutney.execution.domain.campaign.JiraReportMapper;
import fr.enedis.chutney.jira.api.JiraXrayEmbeddedApi;
import fr.enedis.chutney.jira.domain.exception.NoJiraConfigurationException;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import fr.enedis.chutney.server.core.domain.execution.ExecutionRequest;
import fr.enedis.chutney.server.core.domain.execution.FailedExecutionAttempt;
import fr.enedis.chutney.server.core.domain.execution.ScenarioExecutionEngine;
import fr.enedis.chutney.server.core.domain.execution.ScenarioExecutionEngineAsync;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistory;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistoryRepository;
import fr.enedis.chutney.server.core.domain.execution.report.ScenarioExecutionReport;
import fr.enedis.chutney.server.core.domain.execution.report.ServerReportStatus;
import fr.enedis.chutney.server.core.domain.instrument.ChutneyMetrics;
import fr.enedis.chutney.server.core.domain.scenario.ScenarioNotFoundException;
import fr.enedis.chutney.server.core.domain.scenario.ScenarioNotParsableException;
import fr.enedis.chutney.server.core.domain.scenario.TestCaseRepository;
import fr.enedis.chutney.server.core.domain.scenario.campaign.Campaign;
import fr.enedis.chutney.server.core.domain.scenario.campaign.CampaignExecution;
import fr.enedis.chutney.server.core.domain.scenario.campaign.CampaignExecutionReportBuilder;
import fr.enedis.chutney.server.core.domain.scenario.campaign.ScenarioExecutionCampaign;
import fr.enedis.chutney.server.core.domain.scenario.campaign.TestCaseDataset;
import fr.enedis.chutney.tools.Try;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CampaignExecutionEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(Campaign.class);
    private final ExecutorService executor;
    private final CampaignRepository campaignRepository;
    private final CampaignExecutionRepository campaignExecutionRepository;
    private final ScenarioExecutionEngine scenarioExecutionEngine;
    private final ScenarioExecutionEngineAsync scenarioExecutionEngineAsync;
    private final ExecutionHistoryRepository executionHistoryRepository;
    private final TestCaseRepository testCaseRepository;
    private final JiraXrayEmbeddedApi jiraXrayEmbeddedApi;
    private final ChutneyMetrics metrics;
    private final DataSetRepository datasetRepository;
    private final Map<Long, Boolean> currentCampaignExecutionsStopRequests = new ConcurrentHashMap<Long, Boolean>();
    private final ObjectMapper objectMapper;

    public CampaignExecutionEngine(CampaignRepository campaignRepository, CampaignExecutionRepository campaignExecutionRepository, ScenarioExecutionEngine scenarioExecutionEngine, ScenarioExecutionEngineAsync scenarioExecutionEngineAsync, ExecutionHistoryRepository executionHistoryRepository, TestCaseRepository testCaseRepository, JiraXrayEmbeddedApi jiraXrayEmbeddedApi, ChutneyMetrics metrics, ExecutorService executorService, DataSetRepository datasetRepository, ObjectMapper objectMapper) {
        this.campaignRepository = campaignRepository;
        this.campaignExecutionRepository = campaignExecutionRepository;
        this.scenarioExecutionEngine = scenarioExecutionEngine;
        this.scenarioExecutionEngineAsync = scenarioExecutionEngineAsync;
        this.executionHistoryRepository = executionHistoryRepository;
        this.testCaseRepository = testCaseRepository;
        this.jiraXrayEmbeddedApi = jiraXrayEmbeddedApi;
        this.metrics = metrics;
        this.executor = executorService;
        this.datasetRepository = datasetRepository;
        this.objectMapper = objectMapper;
    }

    public CampaignExecution getLastCampaignExecution(Long campaignId) {
        Campaign campaign = this.campaignRepository.findById(campaignId);
        return this.campaignExecutionRepository.getLastExecution(campaign.id);
    }

    public List<CampaignExecution> executeByName(String campaignName, String environment, DataSet dataset, String userId) {
        List<Campaign> campaigns = this.campaignRepository.findByName(campaignName);
        return campaigns.stream().map(campaign -> this.selectExecutionEnvironment((Campaign)campaign, environment)).map(campaign -> this.executeScenarioInCampaign((Campaign)campaign, userId, dataset)).collect(Collectors.toList());
    }

    public List<CampaignExecution> executeByName(String campaignName, String environment, String userId) {
        return this.executeByName(campaignName, environment, null, userId);
    }

    public CampaignExecution executeById(Long campaignId, String environment, DataSet dataset, String userId) {
        return Optional.ofNullable(this.campaignRepository.findById(campaignId)).map(campaign -> this.selectExecutionEnvironment((Campaign)campaign, environment)).map(campaign -> this.executeScenarioInCampaign((Campaign)campaign, userId, dataset)).orElseThrow(() -> new CampaignNotFoundException(campaignId));
    }

    public CampaignExecution executeById(Long campaignId, String userId) {
        return this.executeById(campaignId, null, null, userId);
    }

    public void executeScheduledCampaign(Long campaignId, String environment, String datasetId, String userId) {
        DataSet dataset = this.datasetRepository.findById(datasetId);
        if (!DataSet.NO_DATASET.equals((Object)dataset)) {
            this.executeById(campaignId, environment, dataset, userId);
        } else {
            this.executeById(campaignId, environment, null, userId);
        }
    }

    public Optional<CampaignExecution> currentExecution(Long campaignId, String environment) {
        return this.campaignExecutionRepository.currentExecutions(campaignId).stream().filter(exec -> exec.executionEnvironment.equals(environment)).findAny();
    }

    public void stopExecution(Long executionId) {
        LOGGER.trace("Stop requested for {}", (Object)executionId);
        Optional.ofNullable(this.currentCampaignExecutionsStopRequests.computeIfPresent(executionId, (aLong, aBoolean) -> Boolean.TRUE)).orElseThrow(() -> new CampaignExecutionNotFoundException(null, executionId));
        this.stopScenarioExecutions(executionId);
    }

    private void stopScenarioExecutions(Long campaignExecutionId) {
        try {
            CampaignExecution execution = this.campaignExecutionRepository.getCampaignExecutionById(campaignExecutionId);
            execution.scenarioExecutionReports().stream().filter(ScenarioExecutionCampaign.isRunning()).forEach(sec -> {
                try {
                    this.scenarioExecutionEngineAsync.stop(sec.scenarioId(), sec.execution().executionId());
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot stop scenario execution {} from campaign execution {}", (Object)sec.execution().executionId(), (Object)campaignExecutionId);
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("Cannot stop scenarios from campaign execution {}", (Object)campaignExecutionId);
        }
    }

    public CampaignExecution replayFailedScenariosExecutionsForExecution(Long campaignExecutionId, String userId) {
        CampaignExecution campaignExecution = this.campaignExecutionRepository.getCampaignExecutionById(campaignExecutionId).withoutRetries();
        List failedExecutions = campaignExecution.failedScenarioExecutions();
        if (failedExecutions.isEmpty()) {
            throw new CampaignEmptyExecutionException(campaignExecution);
        }
        Campaign campaign = this.campaignRepository.findById(campaignExecution.campaignId);
        campaign.executionEnvironment(campaignExecution.executionEnvironment);
        return this.executeScenarioInCampaign(failedExecutions, campaign, userId, campaignExecution.dataset);
    }

    CampaignExecution executeScenarioInCampaign(Campaign campaign, String userId) {
        return this.executeScenarioInCampaign(Collections.emptyList(), campaign, userId, null);
    }

    CampaignExecution executeScenarioInCampaign(Campaign campaign, String userId, DataSet dataset) {
        return this.executeScenarioInCampaign(Collections.emptyList(), campaign, userId, dataset);
    }

    CampaignExecution executeScenarioInCampaign(List<ScenarioExecutionCampaign> failedExecutions, Campaign campaign, String userId, DataSet dataset) {
        CampaignExecution campaignExecution;
        CampaignExecution campaignExecution2;
        Long executionId;
        block5: {
            this.verifyHasScenarios(campaign);
            this.verifyNotAlreadyRunning(campaign);
            executionId = this.campaignExecutionRepository.generateCampaignExecutionId(campaign.id, campaign.executionEnvironment(), dataset);
            campaignExecution2 = CampaignExecutionReportBuilder.builder().executionId(executionId).campaignId(campaign.id).campaignName(campaign.title).partialExecution(!failedExecutions.isEmpty()).environment(campaign.executionEnvironment()).dataset(Optional.ofNullable(dataset).orElse(Optional.ofNullable(campaign.executionDataset()).map(ds -> DataSet.builder().withId(ds).withName("").build()).orElse(null))).userId(userId).build();
            this.campaignExecutionRepository.startExecution(campaign.id, campaignExecution2);
            this.currentCampaignExecutionsStopRequests.put(executionId, Boolean.FALSE);
            if (!failedExecutions.isEmpty()) break block5;
            CampaignExecution campaignExecution3 = this.execute(campaign, campaignExecution2, campaign.scenarios);
            campaignExecution2.endCampaignExecution();
            LOGGER.info("Save campaign {} execution {} with status {}", new Object[]{campaign.id, campaignExecution2.executionId, campaignExecution2.status()});
            this.currentCampaignExecutionsStopRequests.remove(executionId);
            this.campaignExecutionRepository.stopExecution(campaign.id, campaign.executionEnvironment());
            Try.exec(() -> {
                this.campaignExecutionRepository.saveCampaignExecution(campaign.id, campaignExecution2);
                return null;
            }).ifFailed(e -> LOGGER.error("Error saving report of campaign {} execution {}", (Object)campaign.id, (Object)campaignExecution.executionId));
            Try.exec(() -> {
                this.metrics.onCampaignExecutionEnded(campaign, campaignExecution2);
                return null;
            }).ifFailed(e -> LOGGER.error("Error saving metrics for campaign {} execution {}", (Object)campaign.id, (Object)campaignExecution.executionId));
            return campaignExecution3;
        }
        try {
            List<Campaign.CampaignScenario> campaignScenarios = failedExecutions.stream().map(ScenarioExecutionCampaign::execution).map(sec -> new Campaign.CampaignScenario(sec.scenarioId(), (String)sec.dataset().map(ds -> ds.id).orElse(null))).toList();
            campaignExecution = this.execute(campaign, campaignExecution2, campaignScenarios);
        }
        catch (Exception e2) {
            try {
                LOGGER.error("Not managed exception occurred", (Throwable)e2);
                throw new RuntimeException(e2);
            }
            catch (Throwable throwable) {
                campaignExecution2.endCampaignExecution();
                LOGGER.info("Save campaign {} execution {} with status {}", new Object[]{campaign.id, campaignExecution2.executionId, campaignExecution2.status()});
                this.currentCampaignExecutionsStopRequests.remove(executionId);
                this.campaignExecutionRepository.stopExecution(campaign.id, campaign.executionEnvironment());
                Try.exec(() -> {
                    this.campaignExecutionRepository.saveCampaignExecution(campaign.id, campaignExecution2);
                    return null;
                }).ifFailed(e -> LOGGER.error("Error saving report of campaign {} execution {}", (Object)campaign.id, (Object)campaignExecution.executionId));
                Try.exec(() -> {
                    this.metrics.onCampaignExecutionEnded(campaign, campaignExecution2);
                    return null;
                }).ifFailed(e -> LOGGER.error("Error saving metrics for campaign {} execution {}", (Object)campaign.id, (Object)campaignExecution.executionId));
                throw throwable;
            }
        }
        campaignExecution2.endCampaignExecution();
        LOGGER.info("Save campaign {} execution {} with status {}", new Object[]{campaign.id, campaignExecution2.executionId, campaignExecution2.status()});
        this.currentCampaignExecutionsStopRequests.remove(executionId);
        this.campaignExecutionRepository.stopExecution(campaign.id, campaign.executionEnvironment());
        Try.exec(() -> {
            this.campaignExecutionRepository.saveCampaignExecution(campaign.id, campaignExecution2);
            return null;
        }).ifFailed(e -> LOGGER.error("Error saving report of campaign {} execution {}", (Object)campaign.id, (Object)campaignExecution.executionId));
        Try.exec(() -> {
            this.metrics.onCampaignExecutionEnded(campaign, campaignExecution2);
            return null;
        }).ifFailed(e -> LOGGER.error("Error saving metrics for campaign {} execution {}", (Object)campaign.id, (Object)campaignExecution.executionId));
        return campaignExecution;
    }

    private CampaignExecution execute(Campaign campaign, CampaignExecution campaignExecution, List<Campaign.CampaignScenario> scenariosToExecute) {
        LOGGER.trace("Execute campaign {} : {}", (Object)campaign.id, (Object)campaign.title);
        List<TestCaseDataset> testCaseDatasets = scenariosToExecute.stream().map(cs -> this.testCaseRepository.findExecutableById(cs.scenarioId()).map(tc -> new TestCaseDataset(tc, this.resolveScenarioDataset((Campaign.CampaignScenario)cs, campaignExecution)))).filter(Optional::isPresent).map(Optional::get).toList();
        campaignExecution.addScenarioExecution(testCaseDatasets, campaign.executionEnvironment());
        try {
            if (campaign.parallelRun) {
                ArrayList toExecute = Lists.newArrayList();
                for (TestCaseDataset t : testCaseDatasets) {
                    toExecute.add(Executors.callable(() -> this.executeScenarioInCampaign(campaign, campaignExecution).accept(t)));
                }
                this.executor.invokeAll(toExecute);
            } else {
                for (TestCaseDataset t : testCaseDatasets) {
                    this.executor.invokeAll(Collections.singleton(Executors.callable(() -> this.executeScenarioInCampaign(campaign, campaignExecution).accept(t))));
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Error ", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error ", (Throwable)e);
        }
        return campaignExecution;
    }

    private Consumer<TestCaseDataset> executeScenarioInCampaign(Campaign campaign, CampaignExecution campaignExecution) {
        return testCaseDataset -> {
            try {
                ScenarioExecutionCampaign scenarioExecution;
                if (!this.currentCampaignExecutionsStopRequests.get(campaignExecution.executionId).booleanValue()) {
                    campaignExecution.startScenarioExecution(testCaseDataset, campaign.executionEnvironment());
                    scenarioExecution = this.executeScenario(campaign, (TestCaseDataset)testCaseDataset, campaignExecution);
                    if (campaign.retryAuto && ServerReportStatus.FAILURE.equals((Object)scenarioExecution.status())) {
                        scenarioExecution = this.executeScenario(campaign, (TestCaseDataset)testCaseDataset, campaignExecution);
                    }
                } else {
                    scenarioExecution = this.generateNotExecutedScenarioExecutionAndReport(campaign, (TestCaseDataset)testCaseDataset, campaignExecution);
                }
                Optional.ofNullable(scenarioExecution).ifPresent(serc -> {
                    campaignExecution.endScenarioExecution(serc);
                    ExecutionHistory.Execution execution = this.executionHistoryRepository.getExecution(serc.scenarioId(), serc.execution().executionId());
                    this.updateJira(campaign, campaignExecution, (ScenarioExecutionCampaign)serc, execution);
                });
            }
            catch (Exception e) {
                LOGGER.error("Error in scenario execution for campaign execution {}", (Object)campaignExecution.executionId, (Object)e);
            }
        };
    }

    private void updateJira(Campaign campaign, CampaignExecution campaignExecution, ScenarioExecutionCampaign serc, ExecutionHistory.Execution execution) {
        if (this.isScenarioCompletelyExecuted(serc.status())) {
            try {
                String datasetId = serc.execution().dataset().map(dataset -> Optional.ofNullable(dataset.id).orElse("")).orElse("");
                this.jiraXrayEmbeddedApi.updateTestExecution(campaign.id, campaignExecution.executionId, serc.scenarioId(), datasetId, JiraReportMapper.from(execution.report(), this.objectMapper));
            }
            catch (NoJiraConfigurationException datasetId) {
            }
            catch (Exception e) {
                LOGGER.warn("Update JIRA failed", (Throwable)e);
            }
        }
    }

    private boolean isScenarioCompletelyExecuted(ServerReportStatus status) {
        return ServerReportStatus.SUCCESS.equals((Object)status) || ServerReportStatus.FAILURE.equals((Object)status);
    }

    private ScenarioExecutionCampaign generateNotExecutedScenarioExecutionAndReport(Campaign campaign, TestCaseDataset testCaseDataset, CampaignExecution campaignExecution) {
        ExecutionRequest executionRequest = this.buildExecutionRequest(campaign, testCaseDataset, campaignExecution);
        ExecutionHistory.Execution execution = this.scenarioExecutionEngine.saveNotExecutedScenarioExecution(executionRequest);
        return new ScenarioExecutionCampaign(testCaseDataset.testcase().id(), testCaseDataset.testcase().metadata().title(), execution.summary());
    }

    private ScenarioExecutionCampaign executeScenario(Campaign campaign, TestCaseDataset testCaseDataset, CampaignExecution campaignExecution) {
        String scenarioName;
        Long executionId;
        try {
            LOGGER.trace("Execute scenario {} for campaign {}", (Object)testCaseDataset.testcase().id(), (Object)campaign.id);
            ExecutionRequest executionRequest = this.buildExecutionRequest(campaign, testCaseDataset, campaignExecution);
            ScenarioExecutionReport scenarioExecutionReport = this.scenarioExecutionEngine.execute(executionRequest);
            executionId = scenarioExecutionReport.executionId;
            scenarioName = scenarioExecutionReport.scenarioName;
        }
        catch (FailedExecutionAttempt e) {
            LOGGER.warn("Failed execution attempt for scenario {} for campaign {}", (Object)testCaseDataset.testcase().id(), (Object)campaign.id);
            executionId = e.executionId;
            scenarioName = e.title;
        }
        catch (ScenarioNotFoundException | ScenarioNotParsableException se) {
            LOGGER.error("Scenario error for scenario {} for campaign {}", new Object[]{testCaseDataset.testcase().id(), campaign.id, se});
            return null;
        }
        ExecutionHistory.Execution execution = this.executionHistoryRepository.getExecution(testCaseDataset.testcase().id(), executionId);
        return new ScenarioExecutionCampaign(testCaseDataset.testcase().id(), scenarioName, execution.summary());
    }

    private DataSet resolveScenarioDataset(Campaign.CampaignScenario campaignScenario, CampaignExecution campaignExecution) {
        return Optional.ofNullable(campaignScenario.datasetId()).map(datasetId -> DataSet.builder().withId(datasetId).withName("").build()).or(() -> Optional.ofNullable(campaignExecution.dataset)).map(ds -> {
            if (ds.id != null && !ds.id.equals(DataSet.CUSTOM_ID)) {
                return this.datasetRepository.findById(ds.id);
            }
            return DataSet.builder().withName("").withDatatable(ds.datatable).withConstants(ds.constants).build();
        }).orElseGet(() -> DataSet.NO_DATASET);
    }

    private ExecutionRequest buildExecutionRequest(Campaign campaign, TestCaseDataset testCaseDataset, CampaignExecution campaignExecution) {
        return new ExecutionRequest(testCaseDataset.testcase(), campaign.executionEnvironment(), campaignExecution.userId, testCaseDataset.dataset(), campaignExecution, campaign.tags);
    }

    private void verifyNotAlreadyRunning(Campaign campaign) {
        Optional<CampaignExecution> currentReport = this.currentExecution(campaign.id, campaign.executionEnvironment());
        if (currentReport.isPresent() && !currentReport.get().status().isFinal()) {
            throw new CampaignAlreadyRunningException(currentReport.get());
        }
    }

    private void verifyHasScenarios(Campaign campaign) {
        if (campaign.scenarios.isEmpty()) {
            throw new CampaignEmptyExecutionException(campaign);
        }
    }

    private Campaign selectExecutionEnvironment(Campaign campaign, String environment) {
        Optional.ofNullable(environment).ifPresent(arg_0 -> ((Campaign)campaign).executionEnvironment(arg_0));
        return campaign;
    }
}

