/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.infra.execution;

import fr.enedis.chutney.engine.api.execution.ExecutionRequestDto;
import fr.enedis.chutney.engine.api.execution.StepExecutionReportDto;
import fr.enedis.chutney.engine.api.execution.TestEngine;
import fr.enedis.chutney.execution.infra.execution.ExecutionRequestMapper;
import fr.enedis.chutney.execution.infra.execution.StepExecutionReportMapperCore;
import fr.enedis.chutney.server.core.domain.execution.ExecutionRequest;
import fr.enedis.chutney.server.core.domain.execution.ServerTestEngine;
import fr.enedis.chutney.server.core.domain.execution.report.StepExecutionReportCore;
import io.reactivex.rxjava3.core.Observable;
import org.apache.commons.lang3.tuple.Pair;

public class ServerTestEngineJavaImpl
implements ServerTestEngine {
    private final TestEngine executionEngine;
    private final ExecutionRequestMapper executionRequestMapper;

    public ServerTestEngineJavaImpl(TestEngine executionEngine, ExecutionRequestMapper executionRequestMapper) {
        this.executionEngine = executionEngine;
        this.executionRequestMapper = executionRequestMapper;
    }

    public StepExecutionReportCore execute(ExecutionRequest executionRequest) {
        ExecutionRequestDto executionRequestDto = this.executionRequestMapper.toDto(executionRequest);
        StepExecutionReportDto stepExecutionReportDto = this.executionEngine.execute(executionRequestDto);
        return StepExecutionReportMapperCore.fromDto(stepExecutionReportDto);
    }

    public Pair<Observable<StepExecutionReportCore>, Long> executeAndFollow(ExecutionRequest executionRequest) {
        ExecutionRequestDto executionRequestDto = this.executionRequestMapper.toDto(executionRequest);
        Long executionId = this.executionEngine.executeAsync(executionRequestDto);
        return Pair.of((Object)this.executionEngine.receiveNotification(executionId).map(StepExecutionReportMapperCore::fromDto), (Object)executionId);
    }

    public void stop(Long executionHash) {
        this.executionEngine.stopExecution(executionHash);
    }

    public void pause(Long executionHash) {
        this.executionEngine.pauseExecution(executionHash);
    }

    public void resume(Long executionHash) {
        this.executionEngine.resumeExecution(executionHash);
    }
}

