/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.infra.storage;

import fr.enedis.chutney.server.core.domain.execution.state.ExecutionStateRepository;
import fr.enedis.chutney.server.core.domain.execution.state.RunningScenarioState;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Repository;

@Repository
public class InMemoryExecutionStateRepository
implements ExecutionStateRepository {
    private final Map<String, RunningScenarioState> internalStorage = new ConcurrentHashMap<String, RunningScenarioState>();

    public Set<RunningScenarioState> runningScenarios() {
        return new HashSet<RunningScenarioState>(this.internalStorage.values());
    }

    public void notifyExecutionStart(String scenarioId) {
        this.internalStorage.put(scenarioId, RunningScenarioState.of((String)scenarioId));
    }

    public void notifyExecutionEnd(String scenarioId) {
        this.internalStorage.remove(scenarioId);
    }

    public Optional<RunningScenarioState> runningState(String scenarioId) {
        return Optional.ofNullable(this.internalStorage.get(scenarioId));
    }
}

