/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.execution.infra.storage.jpa;

import fr.enedis.chutney.engine.domain.execution.engine.step.jackson.ReportObjectMapperConfiguration;
import fr.enedis.chutney.execution.infra.storage.jpa.ReportConverter;
import fr.enedis.chutney.execution.infra.storage.jpa.ScenarioExecutionEntity;
import fr.enedis.chutney.scenario.infra.raw.TagListMapper;
import fr.enedis.chutney.server.core.domain.dataset.DataSet;
import fr.enedis.chutney.server.core.domain.execution.history.ExecutionHistory;
import fr.enedis.chutney.server.core.domain.execution.history.ImmutableExecutionHistory;
import fr.enedis.chutney.server.core.domain.execution.report.ScenarioExecutionReport;
import fr.enedis.chutney.server.core.domain.execution.report.ServerReportStatus;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapsId;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Version;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Optional;

@Entity(name="SCENARIO_EXECUTIONS_REPORTS")
public class ScenarioExecutionReportEntity {
    @Id
    @Column(name="SCENARIO_EXECUTION_ID")
    private Long scenarioExecutionId;
    @OneToOne(fetch=FetchType.LAZY)
    @MapsId
    @JoinColumn(name="SCENARIO_EXECUTION_ID")
    private ScenarioExecutionEntity scenarioExecution;
    @Column(name="REPORT")
    @Basic(fetch=FetchType.LAZY)
    @Convert(converter=ReportConverter.class)
    private String report;
    @Column(name="VERSION")
    @Version
    private Integer version;

    public ScenarioExecutionReportEntity() {
    }

    public ScenarioExecutionReportEntity(ScenarioExecutionEntity scenarioExecution, String report) {
        this.scenarioExecutionId = scenarioExecution.id();
        this.scenarioExecution = scenarioExecution;
        this.report = report;
    }

    public void updateReport(ExecutionHistory.Execution execution) {
        this.report = execution.report();
    }

    public String getReport() {
        return this.report;
    }

    public Long scenarioExecutionId() {
        return this.scenarioExecutionId;
    }

    public ServerReportStatus status() {
        return this.scenarioExecution.status();
    }

    public ExecutionHistory.Execution toDomain() {
        return ImmutableExecutionHistory.Execution.builder().executionId(this.scenarioExecutionId).time(Instant.ofEpochMilli(this.scenarioExecution.executionTime()).atZone(ZoneId.systemDefault()).toLocalDateTime()).duration(this.scenarioExecution.duration().longValue()).status(this.scenarioExecution.status()).info(Optional.ofNullable(this.scenarioExecution.information())).error(Optional.ofNullable(this.scenarioExecution.error())).report(this.report).testCaseTitle(this.scenarioExecution.scenarioTitle()).environment(this.scenarioExecution.environment()).user(this.scenarioExecution.userId()).dataset(Optional.ofNullable(this.getDatasetFromReport())).scenarioId(this.scenarioExecution.scenarioId()).tags(TagListMapper.tagsStringToSet(this.scenarioExecution.tags())).build();
    }

    protected DataSet getDatasetFromReport() {
        try {
            ScenarioExecutionReport scenarioExecutionReport = (ScenarioExecutionReport)ReportObjectMapperConfiguration.reportObjectMapper().readValue(this.report, ScenarioExecutionReport.class);
            if (scenarioExecutionReport.datasetId == null && (scenarioExecutionReport.constants == null || scenarioExecutionReport.constants.isEmpty()) && (scenarioExecutionReport.datatable == null || scenarioExecutionReport.datatable.isEmpty())) {
                return null;
            }
            return DataSet.builder().withName("").withConstants(scenarioExecutionReport.constants).withDatatable(scenarioExecutionReport.datatable).withId(this.scenarioExecution.datasetId()).build();
        }
        catch (IOException e) {
            return null;
        }
    }
}

