/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.index.domain;

import fr.enedis.chutney.index.api.dto.Hit;
import fr.enedis.chutney.index.domain.IndexRepository;
import fr.enedis.chutney.index.infra.LuceneIndexRepository;
import fr.enedis.chutney.scenario.infra.raw.TagListMapper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public abstract class AbstractIndexRepository<T>
implements IndexRepository<T> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractIndexRepository.class);
    protected static final String WHAT = "what";
    protected static final String ID = "id";
    protected static final String TITLE = "title";
    protected static final String CONTENT = "content";
    protected static final String DESCRIPTION = "description";
    protected static final String TAGS = "tags";
    protected final String whatValue;
    private final LuceneIndexRepository luceneIndexRepository;

    protected abstract Document createDocument(T var1);

    protected abstract String getId(T var1);

    protected AbstractIndexRepository(String whatValue, LuceneIndexRepository luceneIndexRepository) {
        this.whatValue = whatValue;
        this.luceneIndexRepository = luceneIndexRepository;
    }

    @Override
    public void save(T entity) {
        Document document = this.createDocument(entity);
        this.luceneIndexRepository.update(this.byIdQuery(this.getId(entity)), document);
    }

    @Override
    public void delete(String id) {
        Query query = this.byIdQuery(id);
        this.luceneIndexRepository.delete(query);
    }

    @Override
    public List<Hit> search(String keyword) {
        TermQuery whatQuery = new TermQuery(new Term(WHAT, this.whatValue));
        String[] keywords = keyword.toLowerCase().split("\\s+");
        BooleanQuery.Builder propertiesQueryBuilder = new BooleanQuery.Builder();
        for (String kw : keywords) {
            BooleanQuery.Builder fieldQueryBuilder = new BooleanQuery.Builder().setMinimumNumberShouldMatch(1).add(this.likeQuery(ID, kw), BooleanClause.Occur.SHOULD).add(this.likeQuery(TITLE, kw), BooleanClause.Occur.SHOULD).add(this.likeQuery(DESCRIPTION, kw), BooleanClause.Occur.SHOULD).add(this.likeQuery(CONTENT, kw), BooleanClause.Occur.SHOULD).add(this.likeQuery(TAGS, kw), BooleanClause.Occur.SHOULD);
            propertiesQueryBuilder.add((Query)fieldQueryBuilder.build(), BooleanClause.Occur.MUST);
        }
        BooleanQuery propertiesQuery = propertiesQueryBuilder.build();
        BooleanQuery query = new BooleanQuery.Builder().add((Query)whatQuery, BooleanClause.Occur.MUST).add((Query)propertiesQuery, BooleanClause.Occur.MUST).build();
        List<Document> documents = this.luceneIndexRepository.search((Query)query, 100);
        return documents.stream().map(doc -> this.highlight((Document)doc, Arrays.asList(keywords))).toList();
    }

    public int count() {
        TermQuery whatQuery = new TermQuery(new Term(WHAT, this.whatValue));
        return this.luceneIndexRepository.count((Query)whatQuery);
    }

    private Query likeQuery(String column, String keyword) {
        return new WildcardQuery(new Term(column, "*" + keyword + "*"));
    }

    private Query byIdQuery(String id) {
        TermQuery whatQuery = new TermQuery(new Term(WHAT, this.whatValue));
        TermQuery idQuery = new TermQuery(new Term(ID, id));
        return new BooleanQuery.Builder().add((Query)idQuery, BooleanClause.Occur.MUST).add((Query)whatQuery, BooleanClause.Occur.MUST).build();
    }

    public Hit highlight(Document doc, List<String> keywords) {
        String highlightedId = this.luceneIndexRepository.highlight(keywords, ID, doc.get(ID), false);
        String highlightedTitle = this.luceneIndexRepository.highlight(keywords, TITLE, doc.get(TITLE), false);
        String highlightedDescription = this.luceneIndexRepository.highlight(keywords, DESCRIPTION, doc.get(DESCRIPTION), false);
        String highlightedContent = this.luceneIndexRepository.highlight(keywords, CONTENT, doc.get(CONTENT), false);
        List<String> highlightedTags = TagListMapper.tagsStringToList(doc.get(TAGS)).stream().map(tag -> this.luceneIndexRepository.highlight(keywords, TAGS, (String)tag, false)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        return new Hit(highlightedId, highlightedTitle, highlightedDescription, highlightedContent, highlightedTags, this.whatValue);
    }
}

