/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.index.infra.config;

import fr.enedis.chutney.index.infra.CustemChutneyAnalyzer;
import fr.enedis.chutney.index.infra.config.IndexConfig;
import fr.enedis.chutney.tools.file.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDiskIndexConfig
implements IndexConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnDiskIndexConfig.class);
    private final IndexWriter indexWriter;
    private final Directory indexDirectory;
    private final Analyzer analyzer;

    public OnDiskIndexConfig(String indexDir, String indexName) {
        Path path = Paths.get(indexDir, indexName);
        this.analyzer = new CustemChutneyAnalyzer();
        this.indexDirectory = this.initFromPath(path);
        this.indexWriter = this.buildIndexWriter(path, indexName);
    }

    private Directory initFromPath(Path path) {
        try {
            FileUtils.initFolder((Path)path);
            return FSDirectory.open((Path)path);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't open index directory", e);
        }
    }

    private IndexWriter buildIndexWriter(Path path, String indexName) {
        IndexWriter tmpIndexWriter;
        try {
            tmpIndexWriter = new IndexWriter(this.indexDirectory, this.getIndexWriterConfig());
            tmpIndexWriter.commit();
        }
        catch (IOException e2) {
            throw new RuntimeException("Couldn't build index writer", e2);
        }
        catch (IllegalArgumentException iae) {
            Optional<Throwable> suppressedCorruptIndexException = Arrays.stream(iae.getSuppressed()).filter(e -> e instanceof CorruptIndexException).findAny();
            if (suppressedCorruptIndexException.isPresent()) {
                LOGGER.warn("Index corrupted... Clean index {} for re-indexing", (Object)indexName, (Object)suppressedCorruptIndexException.get());
                FileUtils.cleanFolder((Path)path);
                try {
                    tmpIndexWriter = new IndexWriter(this.indexDirectory, this.getIndexWriterConfig());
                    tmpIndexWriter.commit();
                }
                catch (IOException e3) {
                    throw new RuntimeException("Couldn't build index writer", e3);
                }
            }
            throw new RuntimeException("Couldn't build index writer", iae);
        }
        return tmpIndexWriter;
    }

    private IndexWriterConfig getIndexWriterConfig() {
        IndexWriterConfig config = new IndexWriterConfig(this.analyzer);
        config.setRAMBufferSizeMB(64.0);
        config.setMergePolicy((MergePolicy)new TieredMergePolicy());
        return config;
    }

    @Override
    public Directory directory() {
        return this.indexDirectory;
    }

    @Override
    public IndexWriter indexWriter() {
        return this.indexWriter;
    }

    @Override
    public Analyzer analyzer() {
        return this.analyzer;
    }
}

