/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.migration.domain;

import fr.enedis.chutney.migration.domain.DataMigrator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;

public class DataMigrationExecutor
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataMigrationExecutor.class);
    private final Long indexingTtlValue;
    private final TimeUnit indexingTtlUnit;
    private final List<DataMigrator> dataMigrators;
    private final ExecutorService executorService;

    public DataMigrationExecutor(Long indexingTtlValue, String indexingTtlUnit, List<DataMigrator> dataMigrators) {
        this.indexingTtlValue = indexingTtlValue;
        this.indexingTtlUnit = TimeUnit.valueOf(indexingTtlUnit);
        this.dataMigrators = dataMigrators;
        this.executorService = Executors.newFixedThreadPool(dataMigrators.size());
    }

    public void run(String ... args) throws Exception {
        LOGGER.info("Start data migration");
        this.dataMigrators.forEach(dataMigrator -> this.executorService.submit(dataMigrator::migrate));
        this.awaitTerminationAfterShutdown(this.executorService);
        LOGGER.info("End data migration");
    }

    public void awaitTerminationAfterShutdown(ExecutorService threadPool) {
        threadPool.shutdown();
        try {
            if (!threadPool.awaitTermination(this.indexingTtlValue, this.indexingTtlUnit)) {
                threadPool.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            threadPool.shutdownNow();
        }
    }
}

