/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.migration.domain;

import fr.enedis.chutney.migration.domain.AbstractMigrator;
import fr.enedis.chutney.scenario.infra.index.ScenarioIndexRepository;
import fr.enedis.chutney.scenario.infra.jpa.ScenarioEntity;
import fr.enedis.chutney.scenario.infra.raw.ScenarioJpaRepository;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.stereotype.Component;

@Component
public class ScenarioMigrator
extends AbstractMigrator<ScenarioEntity> {
    private final ScenarioJpaRepository scenarioJpaRepository;
    private final ScenarioIndexRepository scenarioIndexRepository;

    public ScenarioMigrator(ScenarioJpaRepository scenarioJpaRepository, ScenarioIndexRepository scenarioIndexRepository) {
        this.scenarioJpaRepository = scenarioJpaRepository;
        this.scenarioIndexRepository = scenarioIndexRepository;
    }

    @Override
    protected Slice<ScenarioEntity> findAll(Pageable pageable) {
        return this.scenarioJpaRepository.findByActivated(true, pageable);
    }

    @Override
    protected void index(List<ScenarioEntity> entities) {
        this.scenarioIndexRepository.saveAll(entities);
    }

    @Override
    protected boolean isMigrationDone() {
        return this.scenarioIndexRepository.count() > 0;
    }

    @Override
    protected String getEntityName() {
        return "scenario";
    }
}

