/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.scenario.api;

import fr.enedis.chutney.scenario.api.raw.dto.GwtTestCaseDto;
import fr.enedis.chutney.scenario.api.raw.dto.RawTestCaseDto;
import fr.enedis.chutney.scenario.api.raw.mapper.GwtTestCaseMapper;
import fr.enedis.chutney.scenario.api.raw.mapper.RawTestCaseMapper;
import fr.enedis.chutney.scenario.domain.gwt.GwtTestCase;
import fr.enedis.chutney.security.infra.SpringUserService;
import fr.enedis.chutney.server.core.domain.scenario.AggregatedRepository;
import fr.enedis.chutney.server.core.domain.scenario.ScenarioNotFoundException;
import fr.enedis.chutney.server.core.domain.scenario.TestCase;
import fr.enedis.chutney.server.core.domain.scenario.TestCaseMetadata;
import fr.enedis.chutney.server.core.domain.scenario.TestCaseMetadataImpl;
import java.time.Instant;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/scenario/v2"})
public class GwtTestCaseController {
    private final AggregatedRepository<GwtTestCase> gwtTestCaseRepository;
    private final SpringUserService userService;

    public GwtTestCaseController(AggregatedRepository<GwtTestCase> testCaseRepository, SpringUserService userService) {
        this.gwtTestCaseRepository = testCaseRepository;
        this.userService = userService;
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/{testCaseId}"}, produces={"application/json"})
    public GwtTestCaseDto getTestCase(@PathVariable(value="testCaseId") String testCaseId) {
        return GwtTestCaseMapper.toDto((TestCase)this.gwtTestCaseRepository.findById(testCaseId).orElseThrow(() -> new ScenarioNotFoundException(testCaseId)));
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_WRITE')")
    @PostMapping(path={""}, consumes={"application/json"}, produces={"application/json"})
    public String saveTestCase(@RequestBody GwtTestCaseDto testCase) {
        return this.saveOrUpdate(testCase);
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_WRITE')")
    @PatchMapping(path={""}, consumes={"application/json"}, produces={"application/json"})
    public String updateTestCase(@RequestBody GwtTestCaseDto testCase) {
        return this.saveOrUpdate(testCase);
    }

    private String saveOrUpdate(GwtTestCaseDto testCase) {
        GwtTestCase gwtTestCase = GwtTestCaseMapper.fromDto(testCase);
        return this.gwtTestCaseSave(gwtTestCase);
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_WRITE')")
    @PostMapping(path={"/raw"}, consumes={"application/json"}, produces={"application/json"})
    public String saveTestCase(@RequestBody RawTestCaseDto rawTestCaseDto) {
        GwtTestCase gwtTestCase = RawTestCaseMapper.fromDto(rawTestCaseDto);
        return this.gwtTestCaseSave(gwtTestCase);
    }

    @PreAuthorize(value="hasAuthority('SCENARIO_READ')")
    @GetMapping(path={"/raw/{testCaseId}"}, produces={"application/json"})
    public RawTestCaseDto getTestCaseById(@PathVariable(value="testCaseId") String testCaseId) {
        return RawTestCaseMapper.toDto((GwtTestCase)this.gwtTestCaseRepository.findById(testCaseId).orElseThrow(() -> new ScenarioNotFoundException(testCaseId)));
    }

    private String gwtTestCaseSave(GwtTestCase gwtTestCase) {
        gwtTestCase = GwtTestCase.builder().withMetadata(TestCaseMetadataImpl.TestCaseMetadataBuilder.from((TestCaseMetadata)gwtTestCase.metadata).withUpdateDate(Instant.now()).withAuthor(this.userService.currentUser().getId()).build()).withScenario(gwtTestCase.scenario).build();
        return this.gwtTestCaseRepository.save((TestCase)gwtTestCase);
    }
}

