/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.scenario.domain.gwt;

import fr.enedis.chutney.scenario.domain.gwt.GwtStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GwtScenario {
    public final String title;
    public final String description;
    public final List<GwtStep> givens;
    public final GwtStep when;
    public final List<GwtStep> thens;

    private GwtScenario(String title, String description, List<GwtStep> givens, GwtStep when, List<GwtStep> thens) {
        this.title = title;
        this.description = description;
        this.givens = givens;
        this.when = when;
        this.thens = thens;
    }

    public List<GwtStep> steps() {
        ArrayList<GwtStep> all = new ArrayList<GwtStep>(this.givens);
        all.add(this.when);
        all.addAll(this.thens);
        return Collections.unmodifiableList(all);
    }

    public String toString() {
        return "GwtScenario{givens=" + String.valueOf(this.givens) + ", when=" + String.valueOf(this.when) + ", thens=" + String.valueOf(this.thens) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GwtScenario that = (GwtScenario)o;
        return this.givens.equals(that.givens) && this.when.equals(that.when) && this.thens.equals(that.thens);
    }

    public int hashCode() {
        return Objects.hash(this.givens, this.when, this.thens);
    }

    public static GwtScenarioBuilder builder() {
        return new GwtScenarioBuilder();
    }

    public static class GwtScenarioBuilder {
        private String title;
        private String description;
        private List<GwtStep> givens;
        private GwtStep when;
        private List<GwtStep> thens;

        private GwtScenarioBuilder() {
        }

        public GwtScenario build() {
            return new GwtScenario(Optional.ofNullable(this.title).orElse(""), Optional.ofNullable(this.description).orElse(""), Optional.ofNullable(this.givens).orElse(Collections.emptyList()), Optional.ofNullable(this.when).orElseThrow(IllegalStateException::new), Optional.ofNullable(this.thens).orElse(Collections.emptyList()));
        }

        public GwtScenarioBuilder withTitle(String title) {
            this.title = title;
            return this;
        }

        public GwtScenarioBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public GwtScenarioBuilder withGivens(List<GwtStep> givens) {
            this.givens = Collections.unmodifiableList(givens);
            return this;
        }

        public GwtScenarioBuilder withWhen(GwtStep when) {
            this.when = when;
            return this;
        }

        public GwtScenarioBuilder withThens(List<GwtStep> thens) {
            this.thens = Collections.unmodifiableList(thens);
            return this;
        }
    }
}

