/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.scenario.domain.gwt;

import fr.enedis.chutney.scenario.domain.gwt.GwtStepImplementation;
import fr.enedis.chutney.scenario.domain.gwt.Strategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class GwtStep {
    public static GwtStep NONE = new GwtStep("", Collections.emptyList(), GwtStepImplementation.NONE, Strategy.NONE, Optional.empty());
    public final String description;
    public final List<GwtStep> subSteps;
    public final Optional<GwtStepImplementation> implementation;
    public final Optional<Strategy> strategy;
    public final Optional<String> xRef;

    private GwtStep(String description, List<GwtStep> subSteps, Optional<GwtStepImplementation> implementation, Optional<Strategy> strategy, Optional<String> xRef) {
        this.description = description;
        this.subSteps = subSteps;
        this.implementation = implementation;
        this.strategy = strategy;
        this.xRef = xRef;
    }

    public static GwtStepBuilder builder() {
        return new GwtStepBuilder();
    }

    public String toString() {
        return "GwtStep{description='" + this.description + "', subSteps=" + String.valueOf(this.subSteps) + ", implementation=" + this.implementation.map(GwtStepImplementation::toString).orElse("{}") + ", strategy=" + this.strategy.map(Strategy::toString).orElse("{}") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GwtStep gwtStep = (GwtStep)o;
        return this.description.equals(gwtStep.description) && this.subSteps.equals(gwtStep.subSteps) && this.implementation.equals(gwtStep.implementation) && this.strategy.equals(gwtStep.strategy);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.subSteps, this.implementation, this.strategy);
    }

    public static class GwtStepBuilder {
        private String description;
        private Optional<String> xRef;
        private List<GwtStep> subSteps;
        private Optional<GwtStepImplementation> implementation;
        private Optional<Strategy> strategy;

        private GwtStepBuilder() {
        }

        public GwtStep build() {
            return new GwtStep(Optional.ofNullable(this.description).orElse(""), Optional.ofNullable(this.subSteps).orElse(Collections.emptyList()), Optional.ofNullable(this.implementation).orElse(GwtStepImplementation.NONE), Optional.ofNullable(this.strategy).orElse(Strategy.NONE), Optional.ofNullable(this.xRef).orElse(Optional.empty()));
        }

        public GwtStepBuilder withXRef(String xRef) {
            this.xRef = Optional.ofNullable(xRef);
            return this;
        }

        public GwtStepBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public GwtStepBuilder withSubSteps(GwtStep ... subSteps) {
            this.subSteps = Arrays.asList(subSteps);
            return this;
        }

        public GwtStepBuilder withSubSteps(List<GwtStep> subSteps) {
            this.subSteps = subSteps;
            return this;
        }

        public GwtStepBuilder withImplementation(GwtStepImplementation implementation) {
            this.implementation = Optional.ofNullable(implementation);
            return this;
        }

        public GwtStepBuilder withStrategy(Strategy strategy) {
            this.strategy = Optional.ofNullable(strategy);
            return this;
        }
    }
}

