/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.scenario.infra.index;

import fr.enedis.chutney.index.domain.AbstractIndexRepository;
import fr.enedis.chutney.index.infra.LuceneIndexRepository;
import fr.enedis.chutney.scenario.infra.jpa.ScenarioEntity;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class ScenarioIndexRepository
extends AbstractIndexRepository<ScenarioEntity> {
    public ScenarioIndexRepository(@Qualifier(value="scenarioLuceneIndexRepository") LuceneIndexRepository luceneIndexRepository) {
        super("scenario", luceneIndexRepository);
    }

    @Override
    protected Document createDocument(ScenarioEntity scenario) {
        Document document = new Document();
        document.add((IndexableField)new StringField("what", this.whatValue, Field.Store.YES));
        document.add((IndexableField)new StringField("id", scenario.getId().toString(), Field.Store.YES));
        document.add((IndexableField)new TextField("title", scenario.getTitle(), Field.Store.YES));
        document.add((IndexableField)new TextField("description", scenario.getDescription(), Field.Store.YES));
        document.add((IndexableField)new TextField("content", scenario.getContent(), Field.Store.YES));
        document.add((IndexableField)new TextField("tags", scenario.getTags(), Field.Store.YES));
        return document;
    }

    @Override
    protected String getId(ScenarioEntity scenario) {
        return scenario.getId().toString();
    }
}

