/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.scenario.infra.raw;

import fr.enedis.chutney.scenario.infra.jpa.ScenarioEntity;
import jakarta.persistence.QueryHint;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;

public interface ScenarioJpaRepository
extends JpaRepository<ScenarioEntity, Long>,
JpaSpecificationExecutor<ScenarioEntity> {
    @Query(value="SELECT s.version FROM SCENARIO s WHERE s.id = :id")
    public Optional<Integer> lastVersion(@Param(value="id") Long var1);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public Optional<ScenarioEntity> findByIdAndActivated(Long var1, Boolean var2);

    public List<ScenarioEntity> findByActivated(Boolean var1);

    public Slice<ScenarioEntity> findByActivated(Boolean var1, Pageable var2);

    @Query(value="SELECT new fr.enedis.chutney.scenario.infra.jpa.ScenarioEntity(s.id, s.title, s.description, s.tags, s.creationDate, s.activated, s.userId, s.updateDate, s.version, s.defaultDataset)\nFROM SCENARIO s\nWHERE s.id = :id\n  AND s.activated = :activated\n")
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public Optional<ScenarioEntity> findMetaDataByIdAndActivated(@Param(value="id") Long var1, @Param(value="activated") Boolean var2);

    @Query(value="SELECT new fr.enedis.chutney.scenario.infra.jpa.ScenarioEntity(s.id, s.title, s.description, s.tags, s.creationDate, s.activated, s.userId, s.updateDate, s.version, s.defaultDataset)\nFROM SCENARIO s\nWHERE s.activated = true\n")
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public List<ScenarioEntity> findMetaDataByActivatedTrue();

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    public List<ScenarioEntity> findByActivatedTrueAndDefaultDataset(String var1);

    @Modifying
    @Query(nativeQuery=true, value="INSERT INTO SCENARIO (ID, TITLE, DESCRIPTION, CONTENT, TAGS, CREATION_DATE, ACTIVATED, USER_ID, UPDATE_DATE, VERSION, DEFAULT_DATASET_ID) VALUES (:id, :title, :description, :content, :tags, :creationDate, :activated, :userId, :updateDate, :version, :defaultDataset)")
    public void saveWithExplicitId(@Param(value="id") Long var1, @Param(value="title") String var2, @Param(value="description") String var3, @Param(value="content") String var4, @Param(value="tags") String var5, @Param(value="creationDate") Long var6, @Param(value="activated") Boolean var7, @Param(value="userId") String var8, @Param(value="updateDate") Long var9, @Param(value="version") Integer var10, @Param(value="defaultDataset") String var11);
}

