/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.security;

import com.nimbusds.jose.JOSEException;
import fr.enedis.chutney.security.HttpLoginFailureHandler;
import fr.enedis.chutney.security.HttpLoginSuccessHandler;
import fr.enedis.chutney.security.api.UserDto;
import fr.enedis.chutney.security.domain.AuthenticationService;
import fr.enedis.chutney.security.infra.jwt.ChutneyJwtAuthenticationConverter;
import fr.enedis.chutney.security.infra.jwt.ChutneyJwtProperties;
import fr.enedis.chutney.security.infra.jwt.JwtUtil;
import fr.enedis.chutney.security.infra.sso.OAuth2TokenAuthenticationFilter;
import fr.enedis.chutney.security.infra.sso.SsoOpenIdConnectConfigProperties;
import fr.enedis.chutney.server.core.domain.security.Authorization;
import fr.enedis.chutney.server.core.domain.security.User;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.boot.autoconfigure.security.oauth2.server.servlet.OAuth2AuthorizationServerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.DefaultOAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.authentication.OpaqueTokenAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.SpringOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.web.authentication.BearerTokenAuthenticationFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
@EnableConfigurationProperties(value={OAuth2AuthorizationServerProperties.class, SsoOpenIdConnectConfigProperties.class})
@ConditionalOnProperty(value={"chutney.security.enabled"}, havingValue="true", matchIfMissing=true)
public class ChutneyWebSecurityConfig {
    private static final String LOGIN_URL = "/api/v1/user/login";
    private static final String API_BASE_URL_PATTERN = "/api/**";
    @Value(value="${management.endpoints.web.base-path:/actuator}")
    protected String actuatorBaseUrl;
    @Value(value="${server.ssl.enabled:true}")
    private Boolean sslEnabled;

    @Bean
    public JwtUtil jwtUtil(ChutneyJwtProperties chutneyJwtProperties) throws JOSEException {
        return new JwtUtil(chutneyJwtProperties);
    }

    @Bean
    public OAuth2TokenAuthenticationFilter oAuth2TokenAuthenticationFilter(JwtUtil jwtUtil, AuthenticationService authenticationService) {
        return new OAuth2TokenAuthenticationFilter(jwtUtil, authenticationService);
    }

    @Bean
    public JwtDecoder jwtDecoder(JwtUtil jwtUtil) throws JOSEException {
        return jwtUtil.nimbusJwtDecoder();
    }

    @Bean
    ChutneyJwtAuthenticationConverter chutneyJwtAuthenticationConverter(AuthenticationService authenticationService) {
        return new ChutneyJwtAuthenticationConverter(authenticationService);
    }

    @Bean
    AuthenticationManagerResolver<HttpServletRequest> tokenAuthenticationManagerResolver(JwtDecoder jwtDecoder, @Nullable OpaqueTokenIntrospector opaqueTokenIntrospector, ChutneyJwtAuthenticationConverter jwtConverter, RestOperations restOperations) {
        JwtAuthenticationProvider jwtAuthenticationProvider = new JwtAuthenticationProvider(jwtDecoder);
        jwtAuthenticationProvider.setJwtAuthenticationConverter((Converter)jwtConverter);
        OpaqueTokenIntrospector opaqueTokenIntrospectorFinal = opaqueTokenIntrospector != null ? opaqueTokenIntrospector : token -> new DefaultOAuth2AuthenticatedPrincipal(Collections.emptyMap(), Collections.emptyList());
        ProviderManager jwt = new ProviderManager(new AuthenticationProvider[]{jwtAuthenticationProvider});
        ProviderManager opaqueToken = new ProviderManager(new AuthenticationProvider[]{new OpaqueTokenAuthenticationProvider(opaqueTokenIntrospectorFinal)});
        return arg_0 -> this.lambda$tokenAuthenticationManagerResolver$1((AuthenticationManager)jwt, (AuthenticationManager)opaqueToken, arg_0);
    }

    private boolean useJwt(HttpServletRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader != null && authorizationHeader.startsWith("Bearer ")) {
            String token = authorizationHeader.substring(7);
            return token.split("\\.").length == 3;
        }
        return false;
    }

    @Bean
    @ConfigurationProperties(prefix="chutney.security.cors")
    CorsConfiguration corsConfiguration() {
        return new CorsConfiguration();
    }

    @Bean
    UrlBasedCorsConfigurationSource corsConfigurationSource(CorsConfiguration corsConfiguration) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", corsConfiguration);
        return source;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http, AuthenticationManagerResolver<HttpServletRequest> tokenAuthenticationManagerResolver, OAuth2TokenAuthenticationFilter oAuth2TokenAuthenticationFilter, JwtUtil jwtUtil, CorsConfigurationSource corsConfigurationSource) throws Exception {
        this.configureBaseHttpSecurity(http);
        UserDto anonymous = this.anonymous();
        http.cors(Customizer.withDefaults()).anonymous(anonymousConfigurer -> anonymousConfigurer.principal((Object)anonymous).authorities(new ArrayList<GrantedAuthority>(anonymous.getAuthorities()))).authorizeHttpRequests(httpRequest -> {
            HandlerMappingIntrospector introspector = new HandlerMappingIntrospector();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)httpRequest.requestMatchers(new RequestMatcher[]{new MvcRequestMatcher(introspector, LOGIN_URL)})).permitAll().requestMatchers(new RequestMatcher[]{new MvcRequestMatcher(introspector, "/api/v1/info/**")})).permitAll().requestMatchers(new RequestMatcher[]{new MvcRequestMatcher(introspector, "/api/v1/sso/**")})).permitAll().requestMatchers(new RequestMatcher[]{new MvcRequestMatcher(introspector, API_BASE_URL_PATTERN)})).authenticated().requestMatchers(new RequestMatcher[]{new MvcRequestMatcher(introspector, this.actuatorBaseUrl + "/**")})).hasAuthority(Authorization.ADMIN_ACCESS.name()).anyRequest()).permitAll();
        }).oauth2ResourceServer(oauth2 -> oauth2.authenticationManagerResolver(tokenAuthenticationManagerResolver)).formLogin(httpSecurityFormLoginConfigurer -> ((FormLoginConfigurer)((FormLoginConfigurer)httpSecurityFormLoginConfigurer.loginProcessingUrl(LOGIN_URL)).successHandler((AuthenticationSuccessHandler)new HttpLoginSuccessHandler(jwtUtil))).failureHandler((AuthenticationFailureHandler)new HttpLoginFailureHandler())).httpBasic(Customizer.withDefaults()).addFilterBefore((Filter)new CorsFilter(corsConfigurationSource), BearerTokenAuthenticationFilter.class).addFilterAfter((Filter)oAuth2TokenAuthenticationFilter, BearerTokenAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    private void configureBaseHttpSecurity(HttpSecurity http) throws Exception {
        http.csrf(AbstractHttpConfigurer::disable).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).exceptionHandling(httpSecurityExceptionHandlingConfigurer -> httpSecurityExceptionHandlingConfigurer.authenticationEntryPoint((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED))).requiresChannel(this.requireChannel(this.sslEnabled));
    }

    private UserDto anonymous() {
        UserDto anonymous = new UserDto();
        anonymous.setId(User.ANONYMOUS.id);
        anonymous.setName(User.ANONYMOUS.id);
        anonymous.grantAuthority("ANONYMOUS");
        return anonymous;
    }

    private Customizer<ChannelSecurityConfigurer.ChannelRequestMatcherRegistry> requireChannel(Boolean sslEnabled) {
        if (sslEnabled.booleanValue()) {
            return channelRequestMatcherRegistry -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channelRequestMatcherRegistry.anyRequest()).requiresSecure();
        }
        return channelRequestMatcherRegistry -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channelRequestMatcherRegistry.anyRequest()).requiresInsecure();
    }

    private /* synthetic */ AuthenticationManager lambda$tokenAuthenticationManagerResolver$1(AuthenticationManager jwt, AuthenticationManager opaqueToken, HttpServletRequest request) {
        return this.useJwt(request) ? jwt : opaqueToken;
    }

    @Configuration
    @Profile(value={"sso-auth"})
    public static class SsoConfiguration {
        @Bean
        public RestOperations restOperations(SsoOpenIdConnectConfigProperties ssoOpenIdConnectConfigProperties) {
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            if (ssoOpenIdConnectConfigProperties.proxyHost != null && !ssoOpenIdConnectConfigProperties.proxyHost.isEmpty()) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ssoOpenIdConnectConfigProperties.proxyHost, (int)ssoOpenIdConnectConfigProperties.proxyPort));
                requestFactory.setProxy(proxy);
            }
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
            restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(ssoOpenIdConnectConfigProperties.clientId, ssoOpenIdConnectConfigProperties.clientSecret));
            return restTemplate;
        }

        @Bean
        @Primary
        @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.opaquetoken.introspection-uri"})
        public OpaqueTokenIntrospector opaqueTokenIntrospector(OAuth2ResourceServerProperties properties, RestOperations restOperations) {
            return new SpringOpaqueTokenIntrospector(properties.getOpaquetoken().getIntrospectionUri(), restOperations);
        }
    }
}

