/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.security.api;

import fr.enedis.chutney.security.api.AuthorizationMapper;
import fr.enedis.chutney.security.api.AuthorizationsDto;
import fr.enedis.chutney.security.domain.Authorizations;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/authorizations"})
public class AuthorizationController {
    private final Authorizations authorizations;

    public AuthorizationController(Authorizations authorizations) {
        this.authorizations = authorizations;
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @PostMapping(path={""}, consumes={"application/json"}, produces={"application/json"})
    public void save(@RequestBody AuthorizationsDto authorizations) {
        this.authorizations.save(AuthorizationMapper.fromDto(authorizations));
    }

    @PreAuthorize(value="hasAuthority('ADMIN_ACCESS')")
    @GetMapping(path={""}, produces={"application/json"})
    public AuthorizationsDto read() {
        return AuthorizationMapper.toDto(this.authorizations.read());
    }
}

